% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggpiestats_subtitles.R
\name{subtitle_contingency_tab}
\alias{subtitle_contingency_tab}
\title{Making text subtitle for contingency analysis (Pearson's chi-square
test for independence for between-subjects design or McNemar's test for
within-subjects design)}
\usage{
subtitle_contingency_tab(data, main, condition, counts = NULL,
  nboot = 100, paired = FALSE, stat.title = NULL,
  conf.level = 0.95, conf.type = "norm", simulate.p.value = FALSE,
  B = 2000, bias.correct = FALSE, k = 2, messages = TRUE, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{main}{The variable to use as the \strong{rows} in the
contingency table.}

\item{condition}{The variable to use as the \strong{columns} in the contingency
table.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation (Default).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{paired}{Logical indicating whether data came from a within-subjects
design study (Default: \code{FALSE}). If \code{TRUE}, McNemar test subtitle will be
returned. If \code{FALSE}, Pearson's chi-square test will be returned.}

\item{stat.title}{Title for the effect being investigated with the chi-square
test. The default is \code{NULL}, i.e. no title will be added to describe the
effect being shown. An example of a \code{stat.title} argument will be something
like \code{"main x condition"} or \code{"interaction"}.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{simulate.p.value}{a logical indicating whether to compute
    p-values by Monte Carlo simulation.}

\item{B}{an integer specifying the number of replicates used in the
    Monte Carlo test.}

\item{bias.correct}{If \code{TRUE}, a bias correction will be applied to Cramer's
\emph{V}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Additional arguments (currently ignored).}
}
\description{
Making text subtitle for contingency analysis (Pearson's chi-square
test for independence for between-subjects design or McNemar's test for
within-subjects design)
}
\examples{

# without counts data
subtitle_contingency_tab(
  data = mtcars,
  main = am,
  condition = cyl,
  nboot = 15
)

# with counts data
# in case of no variation, a `NULL` will be returned.
library(jmv)

as.data.frame(HairEyeColor) \%>\%
  dplyr::filter(.data = ., Sex == "Male") \%>\%
  subtitle_contingency_tab(
    data = .,
    main = Hair,
    condition = Sex,
    counts = Freq
  )
}
\seealso{
\code{\link{ggpiestats}}
}
\author{
Indrajeet Patil
}
