% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggcoefstats.R
\name{tfz_labeller}
\alias{tfz_labeller}
\title{Prepare labels with statistic for \code{ggcoefstats} function.}
\usage{
tfz_labeller(tidy_df, glance_df = NULL, statistic, effsize = "eta",
  partial = TRUE, k = 2)
}
\arguments{
\item{tidy_df}{Tidy dataframe from \code{broomExtra::tidy}.}

\item{glance_df}{Glance model summary dataframe from \code{broom::glance}
(default: \code{NULL}). This is optional argument. If provide, the \code{glance}
summary will be used to write \code{caption} for the final plot.}

\item{statistic}{Which statistic is to be displayed (either \code{"t"} or \code{"f"}or
\code{"z"}) in the label. This is especially important if the \code{x} argument in
\code{ggcoefstats} is a dataframe in which case the function wouldn't know what
kind of model it is dealing with.}

\item{effsize}{Character describing the effect size to be displayed: \code{"eta"}
(default) or \code{"omega"}. This argument is relevant
only for models objects of class \code{aov}, \code{anova}, and \code{aovlist}.}

\item{partial}{Logical that decides if partial eta-squared or omega-squared
are returned (Default: \code{TRUE}). If \code{FALSE}, eta-squared or omega-squared
will be returned. Valid only for objects of class \code{aov}, \code{anova}, or
\code{aovlist}.}

\item{k}{Number of decimal places expected for results displayed in labels
(Default : \code{k = 2}).}
}
\description{
Creates text labels for \code{ggcoefstats} plot with the appropriate
statistic (\emph{t}, \emph{z}, or \emph{f}) displayed in the label.
}
\keyword{internal}
