% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{VR_dilemma}
\alias{VR_dilemma}
\title{Virtual reality moral dilemmas.}
\format{A data frame with 68 rows and 4 variables
\itemize{
\item id. Dummy identity number for each participant.
\item order.	The order in which the participants completed the two
sessions: \code{"text_first"} (\code{0}) or \code{"text_second"} (\code{1}).
\item modality.	Describes how the moral dilemmas were presented to the
participants: either in text format (\code{"text"}) or in Virtual Reality
(\code{"vr"}).
\item score.	Proportion of "utilitarian" decisions. In other words, of the
4 decisions, how many affirmative were responses. Range: 0 (all
utilitarian) - 1 (none utilitarian).
}}
\source{
\url{https://psyarxiv.com/ry3ap/}
}
\usage{
VR_dilemma
}
\description{
Virtual reality moral dilemmas.
}
\details{
Dataset from a study where participants completed identical moral
dilemmas in two different sessions held on separate days: in one session,
they read text description of the scenario, while in another session they
completed the same scenarios in Virtual Reality (videos:
\url{https://www.youtube.com/watch?v=ebdU3HhhYs8}). The study investigated
if there was a discrepancy between how people judged the same scenarios
while reading them in text versus experiencing them in virtual reality.
}
\examples{
dim(VR_dilemma)
head(VR_dilemma)
dplyr::glimpse(VR_dilemma)
}
\keyword{datasets}
