% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdotplotstats.R
\name{ggdotplotstats}
\alias{ggdotplotstats}
\title{Dot plot/chart for labeled numeric data.}
\usage{
ggdotplotstats(
  data,
  x,
  y,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  stat.title = NULL,
  subtitle = NULL,
  caption = NULL,
  type = "parametric",
  test.value = 0,
  bf.prior = 0.707,
  bf.message = TRUE,
  effsize.type = "g",
  effsize.noncentral = TRUE,
  conf.level = 0.95,
  nboot = 100,
  k = 2,
  results.subtitle = TRUE,
  point.args = list(color = "black", size = 3, shape = 16),
  test.k = 0,
  test.value.line = FALSE,
  test.value.line.args = list(size = 1),
  test.value.label.args = list(size = 3),
  centrality.parameter = "mean",
  centrality.k = 2,
  centrality.line.args = list(color = "blue", size = 1),
  centrality.label.args = list(color = "blue", size = 3),
  ggplot.component = NULL,
  ggtheme = ggplot2::theme_bw(),
  ggstatsplot.layer = TRUE,
  output = "plot",
  messages = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{A numeric variable.}

\item{y}{Label or grouping variable.}

\item{xlab}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}

\item{ylab}{Labels for \code{x} axis variable (Defaults: \code{"regression coefficient"} and \code{"term"}, resp.).}

\item{title}{The text for the plot title.}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{caption}{The text for the plot caption.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{bf.prior}{A numeric value between \code{0.5} and \code{2} (default \code{0.707}), the
prior width to use in calculating Bayes Factors.}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}). The default is \code{"g"}.}

\item{effsize.noncentral}{Logical indicating whether to use non-central
\emph{t}-distributions for computing the confidence interval for Cohen's \emph{d}
or Hedge's \emph{g} (Default: \code{TRUE}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{point.args}{A list of additional aesthetic arguments passed to
\code{geom_point}.}

\item{test.k}{Integer denoting the number of decimal places expected for
\code{test.value} label. (Default: \code{0} ).}

\item{test.value.line}{Logical that decides whether a line corresponding to
the \code{test.value} should be superimposed on the plot.}

\item{test.value.line.args}{A list of additional
aesthetic arguments to be passed to the \code{geom_line} used to display the
lines corresponding to the centrality parameter and test value.}

\item{test.value.label.args}{A list of additional
aesthetic arguments to be passed to the \code{geom_label} used to display the
label corresponding to the centrality parameter and test value.}

\item{centrality.parameter}{Decides \emph{which} measure of central tendency
(\code{"mean"} or \code{"median"}) is to be displayed as a vertical line. To not show
any parameter, set this to \code{"none"}.}

\item{centrality.k}{Integer denoting the number of decimal places expected
for centrality parameter label. (Default: \code{2}).}

\item{centrality.line.args}{A list of additional
aesthetic arguments to be passed to the \code{geom_line} used to display the
lines corresponding to the centrality parameter and test value.}

\item{centrality.label.args}{A list of additional
aesthetic arguments to be passed to the \code{geom_label} used to display the
label corresponding to the centrality parameter and test value.}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function.}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}

\item{output}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results. If
you have set \code{results.subtitle = FALSE}, then this will return a \code{NULL}.
Setting this to \code{"caption"} will return the expression containing details
about Bayes Factor analysis, but valid only when \code{type = "parametric"} and
\code{bf.message = TRUE}, otherwise this will return a \code{NULL}.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Currently ignored.}
}
\description{
A dot chart (as described by William S. Cleveland) with
statistical details from one-sample test included in the plot as a
subtitle.
}
\examples{
\donttest{
# for reproducibility
set.seed(123)

# plot
ggdotplotstats(
  data = ggplot2::mpg,
  x = cty,
  y = manufacturer,
  conf.level = 0.99,
  test.value = 15,
  test.value.line = TRUE,
  test.line.labeller = TRUE,
  centrality.parameter = "median",
  centrality.k = 0,
  title = "Fuel economy data",
  xlab = "city miles per gallon",
  caption = substitute(
    paste(italic("Source"), ": EPA dataset on http://fueleconomy.gov")
  )
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggdotplotstats.html}
}
\seealso{
\code{\link{grouped_gghistostats}}, \code{\link{gghistostats}},
\code{\link{grouped_ggdotplotstats}}
}
