% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetweenstats_graphics.R
\name{centrality_ggrepel}
\alias{centrality_ggrepel}
\title{Adding labels for mean values.}
\usage{
centrality_ggrepel(
  plot,
  data,
  x,
  y,
  type = "parametric",
  tr = 0.2,
  k = 2L,
  sample.size.label = TRUE,
  centrality.path = FALSE,
  centrality.path.args = list(color = "red", size = 1, alpha = 0.5),
  centrality.point.args = list(size = 5, color = "darkred"),
  centrality.label.args = list(size = 3, nudge_x = 0.4, segment.linetype = 4),
  ...
)
}
\arguments{
\item{plot}{A \code{ggplot} object for which means are to be displayed.}

\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{type}{Type of statistic expected. Four possible options:

\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

Corresponding abbreviations are also accepted: \code{"p"} (for parametric),
\code{"np"} (for nonparametric), \code{"r"} (for robust), or \code{"bf"} (for Bayesian).}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{sample.size.label}{Logical that decides whether sample size information
should be displayed for each level of the grouping variable \code{x} (Default:
\code{TRUE}).}

\item{centrality.path}{Logical that decides whether individual data
points and means, respectively, should be connected using \code{geom_path}. Both
default to \code{TRUE}. Note that \code{point.path} argument is relevant only when
there are two groups (i.e., in case of a \emph{t}-test). In case of large number
of data points, it is advisable to set \code{point.path = FALSE} as these lines
can overwhelm the plot.}

\item{centrality.path.args}{A list of additional aesthetic
arguments passed on to \code{geom_path} connecting raw data points and mean
points.}

\item{centrality.point.args}{A list of additional aesthetic
arguments to be passed to \code{ggplot2::geom_point} and
\code{ggrepel::geom_label_repel} geoms, which are involved in mean plotting.}

\item{centrality.label.args}{A list of additional aesthetic
arguments to be passed to \code{ggplot2::geom_point} and
\code{ggrepel::geom_label_repel} geoms, which are involved in mean plotting.}

\item{...}{Additional arguments.}
}
\description{
Adding labels for mean values.
}
\examples{
# this internal function may not have much utility outside of the package
set.seed(123)
library(ggplot2)

# make a plot
p <- ggplot(data = iris, aes(x = Species, y = Sepal.Length)) +
  geom_boxplot()

# add means
ggstatsplot:::centrality_ggrepel(
  data = iris,
  plot = p,
  x = Species,
  y = Sepal.Length
)
}
\keyword{internal}
