% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_skip.R
\name{label_skip}
\alias{label_skip}
\title{Skip labels on an axis}
\usage{
label_skip(n = 2, start = "left", labeller = NULL)
}
\arguments{
\item{n}{Integer. Display every nth label. Default is \code{2}.}

\item{start}{Where to start the pattern. Either \code{"left"} for first tick (default),
\code{"right"} for last tick, or an integer position (i.e. \code{1} for first tick, \code{2} for second tick, etc.).}

\item{labeller}{Optional function to transform labels before applying skip pattern.
For example \code{\link[=label_date]{label_date()}}. For more complex labeller combinations use \code{\link[scales:compose_label]{scales::compose_label()}}.}
}
\value{
A function that takes a vector of labels and returns a vector with
skipped labels replaced by empty strings.
}
\description{
Creates a labeller function that removes every n-th label on an \code{ggplot2} axis.
Useful for reducing overlapping labels while keeping the major ticks.
}
\examples{
library(ggplot2)
# Default skip labels
ggplot(mtcars, aes(x = mpg, y = wt)) +
  geom_point() +
  scale_x_continuous(labels = label_skip())

# Skip date labels, while keep ticks
ggplot(economics, aes(x = date, y = unemploy)) +
  geom_line() +
  scale_x_date(
    date_breaks = "2 years",
    labels = label_skip(start = "right", labeller = label_date(format = "\%Y"))
  ) +
  theme_bw()

}
