% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_last_value.R
\docType{data}
\name{geom_label_last_value/ stat_last_value}
\alias{geom_label_last_value/ stat_last_value}
\alias{stat_last_value}
\alias{geom_label_last_value}
\alias{geom_text_last_value}
\alias{geom_label_last_value_repel}
\alias{geom_text_last_value_repel}
\alias{StatLastValue}
\alias{StatLastValueRepel}
\title{Add labels or points to the last value of a line chart}
\usage{
stat_last_value(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  nudge_rel = 0,
  nudge_add = 0,
  expand_rel = 0,
  expand_add = 0,
  labeller = NULL,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_label_last_value(
  mapping = NULL,
  data = NULL,
  stat = "last_value",
  position = "identity",
  nudge_rel = 0.015,
  nudge_add = 0,
  expand_rel = 0.05,
  expand_add = 0,
  labeller = NULL,
  hjust = 0,
  ...,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE
)

geom_text_last_value(
  mapping = NULL,
  data = NULL,
  stat = "last_value",
  position = "identity",
  nudge_rel = 0.015,
  nudge_add = 0,
  expand_rel = 0.035,
  expand_add = 0,
  labeller = NULL,
  hjust = 0,
  ...,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE
)

geom_label_last_value_repel(
  mapping = NULL,
  data = NULL,
  stat = "last_value_repel",
  position = "identity",
  nudge_rel = 0.03,
  nudge_add = 0,
  expand_rel = 0.05,
  expand_add = 0,
  labeller = NULL,
  hjust = 0,
  direction = "y",
  min.segment.length = 0.5,
  ...,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE
)

geom_text_last_value_repel(
  mapping = NULL,
  data = NULL,
  stat = "last_value_repel",
  position = "identity",
  nudge_rel = 0.015,
  nudge_add = 0,
  expand_rel = 0.035,
  expand_add = 0,
  labeller = NULL,
  hjust = 0,
  direction = "y",
  min.segment.length = 0.5,
  ...,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}. Commonly used mappings:
\itemize{
\item \strong{x}: position on x-axis
\item \strong{y}: position on y-axis
\item \strong{label}: text to display (defaults to the last y value)
}}

\item{data}{The data frame containing the variables for the plot}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms.}

\item{position}{Position adjustment. Defaults to "identity"}

\item{nudge_rel}{Numeric value specifying how far to nudge the label to the right,
relative to the range of the x-values of the data. Defaults to 0.015 (1.5\% of axis width) for labels.}

\item{nudge_add}{Numeric value specifying an absolute amount to nudge the label (in units of the x-axis).}

\item{expand_rel}{Numeric value specifying how far to expand the axis limits,
relative to the range of the x-values of the data. This can be used to create room for longer text/labels.
For repel functions this has to be large enough to place the text to achieve good results.}

\item{expand_add}{Numeric value specifying an absolute amount to expand the axis limits (in units of the x-axis).}

\item{labeller}{Label function to format the last value.
E.g. \code{\link[scales:label_percent]{scales::label_percent()}}, \code{\link[scales:label_number]{scales::label_number()}}, \code{\link[scales:label_dictionary]{scales::label_dictionary()}}.}

\item{...}{Other arguments passed to \code{\link[ggplot2]{geom_label}}, \code{\link[ggplot2]{geom_text}},
\code{\link[ggrepel]{geom_label_repel}} or \code{\link[ggrepel]{geom_text_repel}}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{stat}{The statistical transformation to use on the data. Defaults to "last_value"}

\item{hjust}{Horizontal text alignment. Defaults to left aligned (0).}

\item{direction}{Direction in which to repel the labels. See \code{\link[ggrepel]{geom_text_repel}}.}

\item{min.segment.length}{Minimum length of the leader line segments. See \code{\link[ggrepel]{geom_text_repel}}.}
}
\value{
A \code{ggplot2} layer that can be added to a plot
}
\description{
Creates a label, point or any geom at the last point of a line (highest x value). This is useful for
line charts where you want to identify each line at its endpoint, write the last value of a
time series at the endpoint or just add a point at the end of a \code{\link[ggplot2]{geom_line}}. This functions
also nudges the last value relative to the length of the x-axis.
The function automatically positions the label slightly to the right of the last point.
There are 5 functions:
\itemize{
\item \code{stat_last_value()}: The core statistical transformation that identifies the last point of a line
(e.g. last date of the time series).
\item \code{geom_label_last_value()}: Adds the last y value or a custom label
after the last observation using \code{\link[ggplot2]{geom_label}}.
\item \code{geom_text_last_value()}: Adds the last y value or a custom text
after the last observation using \code{\link[ggplot2]{geom_text}}.
\item \code{geom_label_last_value_repel()}: Adds non-overlapping labels with \code{\link[ggrepel]{geom_label_repel}}.
\item \code{geom_text_last_value_repel()}: Adds non-overlapping text with \code{\link[ggrepel]{geom_text_repel}}.
}
}
\details{
The following calculated stats can be used further in aes:
\itemize{
\item \code{after_stat(x0)}: the highest x value
\item \code{after_stat(y)}: the y value of the observation with the highest x value.
\item \code{after_stat(label_formatted)}: the formatted y value using the \code{labeller}.
}
}
\examples{
# Basic example with last value labels
library(ggplot2)

ggplot(economics, aes(x = date, y = unemploy)) +
  geom_line() +
  geom_text_last_value()

# Percentages
ggplot(economics, aes(x = date, y = unemploy / pop)) +
  geom_line() +
  geom_label_last_value(labeller = scales::label_percent(accuracy = 0.1))

# Multiple lines with custom labels
ggplot(economics_long, aes(x = date, y = value, color = variable)) +
  geom_line() +
  stat_last_value() + # Add a point at the end
  geom_label_last_value_repel(aes(label = variable),
    expand_rel = 0.1, nudge_rel = 0.05
  ) +
  scale_y_log10() +
  theme_mod_disable_legend()
}
\keyword{datasets}
