% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-data.R
\docType{data}
\name{data_WhiteCells}
\alias{data_WhiteCells}
\alias{WhiteCells}
\title{Aichisons White Cells}
\format{
1 row per point, 60 points in total, 2 experiments x 30 points each, Each point contains data on the following:
\enumerate{ 
\item \strong{No}: ID, S1 to S30
\item \strong{Experiment}: MicroscopicInspection or ImageAnalysis
\item \strong{G}: Fraction Granulocytes
\item \strong{L}: Fraction Lymphocytes
\item \strong{M}: Fraction Monocytes
}
}
\description{
White-cell compositions of 30 blood cells by two different methods
}
\examples{
data(WhiteCells)
   ggtern(WhiteCells,aes(G,L,M)) + 
   geom_density_tern(aes(color=Experiment)) +
   geom_point(aes(shape=Experiment)) +
   facet_wrap(~Experiment,nrow=2)
}
\references{
Aitchison, J. 
            The statistical analysis of compositional data 
            Chapman and Hall London, 1986, pp366
}
\author{
J. Aitchison
}
