% Generated by roxygen2 (4.0.2): do not edit by hand
\name{band}
\alias{band}
\alias{is.prop_band}
\title{A band}
\usage{
band(offset = NULL, mult = NULL)

is.prop_band(x)
}
\arguments{
\item{offset,mult}{Additive and multiplicate offsets used to adjust the
band size. For example, use \code{mult = 0.9} to make a bar take up
90\% of the space allocated for its category.}

\item{x}{object to test for band-ness}
}
\description{
Bands are used to set the width or height on categorical scales - a band
represent the height or width allocated for one level of a factor.
}
\examples{
df <- data.frame(label = c("a", "b", "c"), n = c(10, 9, 4))

base <- df \%>\% ggvis(~label, y2 = 0, y = ~n)
base \%>\% layer_rects(width = band())
base \%>\% layer_rects(width = band(offset = -1))
base \%>\% layer_rects(width = band(mult = 0.9))

# A nominal scale with padding is more symmetrical than band with a mult
base \%>\% layer_rects(width = band(mult = 0.75))
base \%>\% layer_rects(width = band()) \%>\%
  scale_nominal("x", padding = 0.25, points = FALSE)
}

