% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/err.R
\name{RMSE}
\alias{RMSE}
\title{Computes the Root Mean Squared Error}
\usage{
RMSE(model, adj, null = FALSE)
}
\arguments{
\item{model}{nrm model estimate}

\item{adj}{original adjacency matrix}

\item{null}{logical, whether to compute using null model}
}
\value{
numeric, root mean squared error of residuals of nrm model fit
}
\description{
Computes the Root Mean Squared Error
}
\examples{

data('highschool.predictors')
highschool.m <- nrm(w=highschool.predictors[1], adj=contacts.adj, directed=FALSE, selfloops=FALSE)
RMSE(highschool.m, contacts.adj)

}
