% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_encoder.R
\name{data_encoder}
\alias{data_encoder}
\title{Array Data Encoder}
\usage{
data_encoder(values, encoding = c("ASCII", "Base64Binary",
  "GZipBase64Binary"), datatype = NULL, endian = c("little", "big",
  "LittleEndian", "BigEndian"))
}
\arguments{
\item{values}{values to be encoded}

\item{encoding}{encoding of GIFTI values}

\item{datatype}{Passed to \code{\link{convert_binary_datatype}}}

\item{endian}{Endian to pass in \code{\link{readBin}}}
}
\value{
Single character vector
}
\description{
Encodes values for a GIFTI image
}
\examples{
if (have_gifti_test_data()) {
   gii_files = download_gifti_data()
   L = gifti_list(gii_files[1])
   orig = L$DataArray$Data[[1]]
   encoding = attributes(L$DataArray)$Encoding
   datatype = attributes(L$DataArray)$DataType
   endian = attributes(L$DataArray)$Endian
   vals =  data_decoder(orig, encoding = encoding,
   datatype = datatype, endian = endian)
   enc = data_encoder(vals, encoding = encoding,
   datatype = datatype, endian = endian)
   enc == orig
}
}
