% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gips_perm_class.R
\name{gips_perm}
\alias{gips_perm}
\alias{new_gips_perm}
\alias{validate_gips_perm}
\title{Permutation object}
\usage{
gips_perm(x, size)

new_gips_perm(rearranged_cycles, size)

validate_gips_perm(g)
}
\arguments{
\item{x}{An object created with a \code{permutations} package or any object
that can be processed with the \code{\link[permutations:permutation]{permutations::permutation()}} function.}

\item{size}{An integer. Size of a permutation
(AKA cardinality of a set, on which permutation is defined; see examples).}

\item{rearranged_cycles}{A list of rearranged integer vectors.
Each vector corresponds to a single cycle of a permutation.}

\item{g}{Object to be checked whether it is
a proper object of a \code{gips_perm} class.}
}
\value{
\code{gips_perm()} returns an object of
a \code{gips_perm} class after the safety checks.

\code{new_gips_perm()} returns an object of
a \code{gips_perm} class without the safety checks.

\code{validate_gips_perm()} returns its argument unchanged.
If the argument is not a proper element of a \code{gips_perm} class,
it produces an error.
}
\description{
Create permutation objects to be passed to
other functions of the \code{gips} package.
}
\section{Functions}{
\itemize{
\item \code{new_gips_perm()}: Constructor. Only intended for low-level use.

\item \code{validate_gips_perm()}: Validator. Only intended for low-level use.

}}
\section{Methods for a \code{gips} class}{

\itemize{
\item \code{\link[=as.character.gips_perm]{as.character.gips_perm()}}
\item \code{\link[=print.gips_perm]{print.gips_perm()}}
}
}

\examples{
gperm <- gips_perm(permutations::as.word(c(1, 2, 3, 5, 4)), 5)
gperm <- gips_perm(permutations::as.cycle("(5,4)"), 5)
# note the necessity of `size` parameter
gperm <- gips_perm(permutations::as.cycle("(5,4)"), 7)
gperm <- gips_perm("(1,2)(5,4)", 7)
gperm

\donttest{
try(gperm <- gips_perm(permutations::as.cycle("(5,4)"), 3))
# Error, `size` equals 3 while the maximum element is 5.
}

}
\seealso{
\itemize{
\item \code{\link[permutations:permutation]{permutations::permutation()}} - The constructor for the \code{x} parameter.
\item \code{\link[=gips]{gips()}} - The constructor for the \code{gips} class uses
the \code{gips_perm} object as the base object.
}
}
