% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gips_class.R
\name{forget_perms}
\alias{forget_perms}
\title{Forget the permutations for \code{gips} object optimized with \code{save_all_perms = TRUE}}
\usage{
forget_perms(g)
}
\arguments{
\item{g}{An object of class \code{gips}.
A result of a \code{find_MAP(save_all_perms = TRUE)}.}
}
\value{
Returns the same object \code{g} as given,
but without the visited permutation list.
}
\description{
Slim the \code{gips} object by forgetting the visited permutations from \code{find_MAP(save_all_perms = TRUE)}.
}
\details{
For example, \code{perm_size = 150} and \code{max_iter = 150000} we checked \code{forget_perms()} saves ~350 MB of RAM.
}
\examples{
A <- matrix(rnorm(10 * 10), nrow = 10)
S <- t(A) \%*\% A
g <- gips(S, 13, was_mean_estimated = FALSE)
g_map <- find_MAP(g,
  max_iter = 10, optimizer = "Metropolis_Hastings",
  show_progress_bar = FALSE, save_all_perms = TRUE
)

object.size(g_map) # ~18 KB
g_map_slim <- forget_perms(g_map)
object.size(g_map_slim) # ~8 KB
}
\seealso{
\itemize{
\item \code{\link[=find_MAP]{find_MAP()}} - The \code{forget_perms()} is called on
the output of \code{find_MAP(save_all_perms = TRUE)}.
}
}
