% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tabl.R
\name{tabl}
\alias{tabl}
\title{Make a table from gist or commit class or a list of either}
\usage{
tabl(x, ...)
}
\arguments{
\item{x}{Either a gist or commit class object or a list of either}

\item{...}{Ignored}
}
\description{
Make a table from gist or commit class or a list of either
}
\examples{
\dontrun{
x <- as.gist('f1403260eb92f5dfa7e1')
tabl(x)

# from a list
ss <- gists('minepublic')
tabl(ss[1:3])
## manipulate with dplyr
library("dplyr")
tabl(gists("minepublic")[1:10]) \%>\%
  select(id, description, owner_login) \%>\%
  filter(grepl("gist gist gist", description))

# commits
x <- gists()[[2]] \%>\% commits()
tabl(x[[1]])

## many
x <- sapply(c(gists(), gists()), commits)
tabl(x) \%>\%
  select(id, login, change_status.total, url) \%>\%
  filter(change_status.total > 50)

# pass in a url
gist("https://gist.github.com/expersso/4ac33b9c00751fddc7f8") \%>\% tabl
## many
gg <- gists()
(urls <- vapply(gg, "[[", "", "html_url"))
lapply(urls[1:5], as.gist) \%>\% tabl()
}
}

