% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gist.R
\name{gist}
\alias{gist}
\alias{as.gist}
\title{Get a gist}
\usage{
gist(id, revision = NULL, ...)

as.gist(x)
}
\arguments{
\item{id}{(character) A gist id, or a gist URL}

\item{revision}{(character) A sha. optional}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}

\item{x}{Object to coerce. Can be an integer (gist id), string
(gist id), a gist, or an list that can be coerced to a gist.}
}
\description{
Get a gist
}
\details{
If a file is larger than ~1 MB, the content of the file given back
is truncated, so you won't get the entire contents. In the return S3 object
that's printed, we tell you at the bottom whether each file is truncated or
not. If a file is, simply get the \code{raw_url} URL for the file (see
example below), then retrieve from that. If the file is very big, you may
need to clone the file using git, etc.
}
\examples{
\dontrun{
gist('f1403260eb92f5dfa7e1')

as.gist('f1403260eb92f5dfa7e1')
as.gist(10)
as.gist(gist('f1403260eb92f5dfa7e1'))

# get a specific revision of a gist
id <- 'c1e2cb547d9f22bd314da50fe9c7b503'
gist(id, 'a5bc5c143beb697f23b2c320ff5a8dacf960b0f3')
gist(id, 'b70d94a8222a4326dff46fc85bc69d0179bd1da2')
gist(id, '648bb44ab9ae59d57b4ea5de7d85e24103717e8b')
gist(id, '0259b13c7653dc95e20193133bcf71811888cbe6')

# from a url, or partial url
x <- "https://gist.github.com/expersso/4ac33b9c00751fddc7f8"
x <- "gist.github.com/expersso/4ac33b9c00751fddc7f8"
x <- "gist.github.com/4ac33b9c00751fddc7f8"
x <- "expersso/4ac33b9c00751fddc7f8"
as.gist(x)

ids <- sapply(gists(), "[[", "id")
gist(ids[1])
gist(ids[2])
gist(ids[3])
gist(ids[4])

gist(ids[1]) \%>\% browse()

## If a gist file is > a certain size it is truncated
## in this case, we let you know in the return object that it is truncated
## e.g.
(bigfile <- gist(id = "b74b878fd7d9176a4c52"))
## then get the raw_url, and retrieve the file
url <- bigfile$files$`plossmall.json`$raw_url
# httr::GET(url)
}
}
