% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/blob.r
\docType{methods}
\name{content}
\alias{content}
\alias{content,git_blob-method}
\title{Content of blob}
\usage{
content(blob, split = TRUE)

\S4method{content}{git_blob}(blob, split = TRUE)
}
\arguments{
\item{blob}{The blob \code{object}.}

\item{split}{Split blob content to text lines. Default TRUE.}
}
\value{
The content of the blob. NA_character_ if the blob is binary.
}
\description{
Content of blob
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Display content of blob.
content(tree(commits(repo)[[1]])["example.txt"])
}
}
\keyword{methods}

