% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gi_write_gitignore.R
\name{gi_write_gitignore}
\alias{gi_write_gitignore}
\title{Append or create a .gitignore file}
\usage{
gi_write_gitignore(fetched_template,
  gitignore_file = here::here(".gitignore"))
}
\arguments{
\item{fetched_template}{Template(s) returned by `gi_fetch_templates()`.}

\item{gitignore_file}{Path of the .gitignore file to modify.}
}
\value{
TRUE if succeeds to write/append the .gitignore, FALSE otherwise.
}
\description{
Use the returned template(s) to append the existing .gitignore file.
}
\examples{
\donttest{
f <- paste0(tempdir(), "/.gitignore")
new_lines <- gi_fetch_templates("r")
gi_write_gitignore(new_lines, f)

unlink(f)
}
}
