% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_module_login.R
\name{glLoginInput}
\alias{glLoginInput}
\alias{glReactiveLogin}
\title{Shiny module to login to GitLab API}
\usage{
glLoginInput(id, login_button = TRUE)

glReactiveLogin(
  input,
  output,
  session,
  gitlab_url,
  project = NULL,
  api_version = 4,
  success_message = "GitLab login successful!",
  failure_message = "GitLab login failed!",
  on_error = function(...) {     stop(failure_message) }
)
}
\arguments{
\item{id}{shiny namespace for the login module}

\item{login_button}{whether to show a login button (TRUE) or be purely reactive (FALSE)}

\item{input}{from shinyServer function, usually not user provided}

\item{output}{from shinyServer function, usually not user provided}

\item{session}{from shinyServer function, usually not user provided}

\item{gitlab_url}{root URL of GitLab instance to login to}

\item{project}{if not NULL, a code{\link{gl_project_connection}} is created to this project}

\item{api_version}{A character with value either "3" or "4" to specify the API version that should be used}

\item{success_message}{message text to be displayed in the UI on successful login}

\item{failure_message}{message text to be displayed in the UI on login failure in addition to HTTP status}

\item{on_error}{function to be returned instead of GitLab connection in case of login failure}
}
\value{
An input or output element for use in shiny UI.
}
\description{
The UI contains a login and a password field as well as an (optional)
login button. The server side function returns a reactive GitLab connection, just as \code{\link[=gl_connection]{gl_connection()}}
and \code{\link[=gl_project_connection]{gl_project_connection()}}.
}
\details{
\code{glLoginInput} is supposed to be used inside a \code{shinyUI}, while
\code{glReactiveLogin} is supposed to be passed on to \code{\link[shiny:callModule]{shiny::callModule()}}
}
