% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/givitiCalibrationBasic.R
\name{polynomialLogRegrFw}
\alias{polynomialLogRegrFw}
\title{Forward Selection in Polynomial Logistic Regression}
\usage{
polynomialLogRegrFw(data, thres, maxDeg, startDeg)
}
\arguments{
\item{data}{A \code{data.frame} object with the numeric variables "o", "e"
and "logite", representing the binary outcomes, the probabilities of the
model under evaluation and the logit of the probabilities.
The variable "e" must contain values between 0 and 1. The variable
"o" must assume only the value 0 and 1.}

\item{thres}{A numeric scalar between 0 and 1 representing the significance level
adopted in the forward selection.}

\item{maxDeg}{The maximum degree considered in the forward selection.}

\item{startDeg}{The starting degree in the forward selection.}
}
\value{
A list containing the following components:
\describe{
  \item{fit}{An object of class \code{glm} containig the output of the fit
             of the logistic regression model at the end of the iterative
             forward selection.}
  \item{m}{The degree of the polynomial at the end of the forward selection.}
}
}
\description{
\code{polynomialLogRegrFw} implements a forward selection in a
polynomial logistic regression model.
}
\examples{
e <- runif(100)
logite <- logit(e)
o <- rbinom(100, size = 1, prob = e)
data <- data.frame(e = e, o = o, logite = logite)
polynomialLogRegrFw(data, .95, 4, 1)
}

