
gjamPlot <-
function(output, plotPars){
  
  # output     - list generated by gjamGibbs
  # plotPars   - list can include 
  #   sdScale=F  - plot posteriors on standardized scale
  #   trueValues - list can include 'beta', 'y', 'cor', 'cuts'
  
  sdScale  <- F
  ylog     <-  F
  ncolPlot <- 2
  sigOnly  <- T 
  PLOTY <- T
  PLOTX <- T
  ncluster <- min(c(4,ncol(output$y))) - 1
  corLines <- T
  cex <- 1
  holdoutIndex <- numeric(0)
  betaGrid  <- T
  omitSpec  <- NULL
 # outfolder <- 'GJAMoutput'
 # outfile   <- character(0)
  trueValues <- NULL
  censor    <- NULL
  plotAllY  <- F
  TRAITS    <- F
  TV        <- F
  width     <- 9
  height    <- 9
  unstandardX  <- NULL # vector of standard deviations of x, by name, to unstandardize
  CLUSTERPLOTS <- F
  SMALLPLOTS  <- T
  oma <- c(1,1,0,0)
  mar <- c(1,1,1,0)
  tcl <- -0.1
  mgp <- c(0,0,0)
  
  traitList <- typeNames <- classBySpec <- x <- y <- burnin <- richness <- 
  betaZ     <- corSpec <- cutMu <- yMu <- DIC <- score <- missingIndex <- 
  xpredMu <- traitMeanMat <- tMu <- traitPlot <- tMuOrd <- traitTypes <- 
  isFactor <- betaMu <- corMu <- modelSummary <- NULL
  
  for(k in 1:length(output))assign( names(output)[k], output[[k]] )
  for(k in 1:length(modelSummary))assign( names(modelSummary)[k], modelSummary[[k]] )
  for(k in 1:length(plotPars))assign( names(plotPars)[k], plotPars[[k]] )
  if( !is.null(traitList) ){
    TRAITS <- T
    for(k in 1:length(traitList))assign( names(traitList)[k], traitList[[k]] )
  }
  if( 'trueValues' %in% names(plotPars) ){
    TV <- T
    for(k in 1:length(trueValues))assign( names(trueValues)[k], trueValues[[k]] )
  }
  
  if(!SMALLPLOTS){
    oma <- c(0,0,0,0)
    mar <- c(4,3,3,2)
    tcl <- -0.5
    mgp <- c(3,1,0)
  }
  
  chainNames <- names(output$chains)
  
  allTypes <- unique(typeNames)
  
  ntypes   <- length(allTypes)
  typeCode <- match(typeNames,allTypes)
  specs    <- rownames(classBySpec)
  Q        <- ncol(x)
  nhold   <- length(holdoutIndex)
  ncut    <- ncol(classBySpec) + 1
  S       <- ncol(y)
  n       <- nrow(y)
  snames  <- colnames(y)
  xnames  <- colnames(x)
  ng      <- nrow(chains$bgibbs)
  gindex  <- burnin:ng
  
  for(k in 1:length(chains)){
    if(length(chains[[k]]) > 0){
      if(is.matrix(chains[[k]])){
        chains[[k]] <- chains[[k]][gindex,]
      } else {
        chains[[k]] <- matrix(chains[[k]])
      }
    }
  }
  
  other    <- which(colnames(y) == 'other')
  omit     <- c(which(colnames(y) %in% omitSpec),other)
  notOther <- notOmit <- c(1:S)
  if(length(other) > 0)notOther <- notOther[notOther != other]
  SO       <- length(notOther)
  if(length(omit) > 0)notOmit <- notOmit[-omit]
  SM       <- length(notOmit)
  
  snames  <- colnames(y)
  xnames  <- colnames(x)
  
  cvec    <- c('black','brown','orange')
  if(ntypes > 4)cvec <- c(cvec,'green','blue')
  colF    <- colorRampPalette(cvec)
  
  ## richness prediction
  nc  <- ncol(richness)
  vv  <- as.numeric(colnames(richness))
  ws  <- rowSums(richness)
  rmu <- rowSums( richness*matrix(vv,n,nc,byrow=T) )/ws
  rse <- sqrt( rowSums( richness*matrix(vv^2,n,nc,byrow=T) )/ws - rmu^2)
  
  rtrue <- y
  rtrue[rtrue > 0] <- 1
  rtrue <- rowSums(rtrue)
  
  if(!TRAITS){
    
  # dev.new(width = width, height = height)
    par(mfrow=c(1,1),bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp)
    
    richnessBySite <- NULL
    
    richnessBySite <- cbind(rtrue,rmu,rse)
    colnames(richnessBySite) <- c('obs','mean','std_err')
    
    .plotObsPred(obs=rtrue,yMean=rmu,nbin=12,xlabel='Observed',ylabel='Predicted',
                POINTS=F)
    abline(0,1,lty=2)
    .plotLabel(' Species richness',cex=1.2,above=T)
    
    readline('no. species may not vary much -- return to continue ')
 #   graphics.off()
  }
  
  xSd <- sqrt( diag(cov(x)) )
  ySd <- sqrt( diag(cov(y[,notOther])) )
  
  tmp <- .omitChainCol(chains$bgibbs,'other')
  omitBC <- tmp$omit
  keepBC <- tmp$keep
  
  tmp <- .omitChainCol(chains$rgibbs,'other')
  omitSC <- tmp$omit
  keepSC <- tmp$keep
  
  tmp <- .omitChainCol(chains$sensGibbs,'other')
  omitCC <- tmp$omit
  keepCC <- tmp$keep
  
  SO <- length(notOther)
  
  bCoeffTable <- .processPars(chains$bgibbs[,keepBC],sigOnly=sigOnly)$summary
  rCoeffTable <- .processPars(chains$rgibbs[,keepSC],sigOnly=sigOnly)$summary
  sigBeta     <- rownames(bCoeffTable)
  sigCor      <- rownames(rCoeffTable)

  betaLab   <- expression( paste('Coefficient matrix ',hat(bold(beta))  ))
  zeroLab   <- expression( paste('ZI coefficient matrix ',hat(bold(gamma))  ))
  corLab    <- expression( paste('Correlation matrix ',hat(bold(R))  ))
  cutLab    <- expression( paste('Partition matrix ',hat(bold(plain(P)))  ))
  
  ################if true parameter values
  
  if(TV){
    
  # dev.new(width = width, height = height)
    par(mfcol=c(3,2),bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp)
    
    if('beta' %in% names(trueValues)){
      cols <- colF(ntypes)
      bCoefftable <- .gjamTrueVest(chains$bgibbs[,keepBC],true=beta[keepBC],
                                   typeCode,allTypes,colors=cols,label = betaLab)
    }
    if( 'betaZ' %in% names(trueValues) ){
      zCoeffTable <- .gjamTrueVest(chains$bzeroGibbs,true=betaZ,
                                   typeCode,allTypes,colors=cols,label=zeroLab)
    }
    if( 'corSpec' %in% names(trueValues) ){
      
      cols <- colF(2^ntypes)
      
      cmat     <- corSpec*0
      cmat[notOther,notOther] <- 1
      cindex   <- which(upper.tri(corSpec))
      pindex   <- which(upper.tri(corSpec),arr.ind=T)
      
      cols <- colF(ntypes + ntypes*(ntypes-1)/2)
      
      xlim <- range(corSpec[cindex])
      ylim <- range(chains$rgibbs[,cindex])
      
      add <- F
      m   <- 1
      combNames <- character(0)
      
      tmp <- matrix( colMeans(chains$rgibbs),S,S)
      diag(tmp) <- 0
      ww  <- which(tmp > .9,arr.ind=T)
      
      for(k in 1:length(allTypes)){
        
        wk <- which(typeNames == allTypes[k])
        wk <- wk[wk %in% notOther]
        wp <- which(pindex[,1] %in% wk & pindex[,2] %in% wk)
        
        if(length(wp) == 1){
          
          combNames <- c(combNames,allTypes[k])
          
          yci <- quantile( chains$rgibbs[,cindex[wp]] ,c(.5,.025,.975))
          xmu <- corSpec[matrix(pindex[wp,],1)]
          if(!add){
            plot(xmu,yci[1],xlim=xlim,ylim=ylim,
                 pch=3,col=m)
            add <- T
          } else {
            points(xmu,yci[1],pch=3,col=m)
          }
          lines( c(xmu,xmu),yci[2:3],col=m,lwd=2)
        }
          
        if(length(wp) > 1){
          
          corTable <- .gjamTrueVest(chains$rgibbs[,cindex[wp]],true=corSpec[pindex[wp,]],
                                    typeCode,allTypes,label=corLab,xlim=xlim,ylim=ylim,
                                    colors=cols[m],legend=F,add=add)
          add <- T
          m <- m + 1
          combNames <- c(combNames,allTypes[k])
        }
        
        if(k < length(allTypes)){
          
          for(j in (k+1):length(allTypes)){
            
            wj <- which(typeNames == allTypes[j])
            wp <- which(pindex[,1] %in% wk & pindex[,2] %in% wj)
            
            if(length(wp) == 1){
              yci <- quantile( chains$rgibbs[,cindex[wp]] ,c(.5,.025,.975))
              xmu <- corSpec[matrix(pindex[wp,],1)]
              if(!add){
                plot(xmu,yci[1],xlim=xlim,ylim=ylim,
                     pch=3,col=m)
              } else {
                points(xmu,yci[1],pch=3,col=m)
              }
              lines( c(xmu,xmu),yci[2:3],col=m,lwd=2)
              
            } else {
              corTable <- .gjamTrueVest(chains$rgibbs[,cindex[wp]],true=corSpec[pindex[wp,]],
                                        typeCode,allTypes,add=add,colors=cols[m],legend=F)
            }
            m <- m + 1
            combNames <- c(combNames,paste(allTypes[k],allTypes[j],sep='-'))
            add <- T
          }
        }
      }
      legend('topleft',combNames,text.col=cols,bty='n',ncol=3,cex=.7)
    }
    if('OC' %in% allTypes & 'cuts' %in% names(trueValues)){
      wc       <- c(1:ncol( cutMu )) + 2
      ctrue    <- cuts[,wc]
      wf       <- which(is.finite(ctrue*cutMu))
      cutTable <- .gjamTrueVest(chains$cgibbs[,wf],true=ctrue[wf],
                                typeCode,allTypes,colors='black',label=cutLab,legend=F)
    }
    readline('simulated beta, corSpec vs betaMu, corMu (95%) -- return to continue')
    #   dev.copy2pdf(file=outFile(outfolder,'trueVsPars.pdf'))
 #   graphics.off()
  }
  
  ##################### partition for ordinal
  
  if('OC' %in% typeNames){
    
  # dev.new(width = width, height = height)
    par( bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp )
  
    wk <- which(typeNames == 'OC')
    nk <- length(wk)
    
    cgibbs <- chains$cgibbs
    
    cgibbs[!is.finite(cgibbs)] <- NA
    cc <- colSums(abs(cgibbs),na.rm=T)
    cg <- cgibbs[,cc > 0]
    
    # vnames <- rownames(cutMu)
    if('cuts' %in% names(trueValues))rownames(cuts) <- rownames(cutMu)
    
    c1 <- names(cc)[cc > 0]
    vnames <- sort(unique(matrix(unlist(strsplit(c1,'_')),ncol=2,byrow=T)[,1]))
    
    colc <- colF(ncol(cutMu))
    
    nk <- length(vnames)
    plot(0,0,xlim=c(0,max(cg,na.rm=T)),ylim=c(1,1+nk),cex=.1,xlab='Unit variance scale',
         ylab='Species',yaxt='n')
    .yaxisHorizLabs(vnames,at=c(1:nk))
    
    
    for(k in 1:length(vnames)){
      
      x1   <- 0
      ym   <- .5
      
      tmp <- .chains2density(cg,varName=vnames[k])
      xt  <- tmp$x
      yt  <- tmp$y
      yt  <- .5*yt/max(yt)
      
      yt <- yt + k
      
      for(j in 1:nrow(xt)){
        
        if('cuts' %in% names(trueValues)){
          lines( rep(cuts[vnames[k],j+2],2),c(k,k+1),lty=2,col=colc[j],lwd=3)
        }
        
        xj <- c(xt[j,],xt[j,ncol(xt)],xt[j,1])
        yj <- c(yt[j,],k,k)
        
        x2 <- which.max(yj)
        xm <- .2*x1 + .8*xj[x2]
        
        polygon(xj,yj,border=colc[j],col=colc[j],lwd=2)
        if(k == length(vnames)) text(xm,ym+k,j,col=colc[j])
        x1 <- xj[x2]
      }
    }
    .plotLabel('Partition by species',above=T)
    
    readline('cuts vs cutMu -- return to continue')
    
 #   dev.copy2pdf(file=outFile(outfolder,'partition.pdf') )
 #   graphics.off()
  }
  
  rmspeAll <- sqrt( mean( (y[,notOther] - yMu[,notOther])^2 ) )
  
  eBySpec <- sqrt( colMeans( (y[,notOther]/rowSums(y[,notOther]) - yMu[,notOther]/rowSums(yMu[,notOther]))^2 ) )
  ordFit  <- order(eBySpec)
  
  fit <- signif( c(DIC,score,rmspeAll), 5)
  names(fit) <- c('DIC','score','rmspe')
  
  ################## predict y
  if(PLOTY){
    
  # dev.new(width = width, height = height)
    
    npp <- length(allTypes) + length(censor)
    nrr <- ceiling(sqrt(npp))
    par( mfrow=c(nrr,nrr), bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp )
    
    ylab <- ' '
    
    for(k in 1:length(allTypes)){
      
      wk    <- which(typeCode == k)
      wk    <- wk[wk %in% notOther]
      wkm   <- wk
      nk    <- nkm <- length(wk)
      censm <- NULL
      wm    <- 1
      CENS  <- F
      add   <- F
      
      if( length(censor) > 0 ){
        if( typeNames[wk[1]] %in% names(censor) ){
          CENS <- T
          wm <- which(names(censor) == typeNames[wk[1]])
        }
      }
      
      for(m in wm){
        
        if(CENS){
          censm <- censor[[m]]
          wkm <- censor[[m]]$columns
          nkm <- length(wkm)
        }
        
        y1 <- y[,wkm]
        yp <- yMu[,wkm]
        
        if(nkm == 1){
          y1 <- matrix(y1,ncol=1)
          yp <- matrix(yp,ncol=1)
        }
        tmp <- .gjamPlotPars(type=typeNames[wk[1]],y1,yp,censm)
        y1 <- tmp$y1; yp <- tmp$yp; nbin <- tmp$nbin; nPerBin <- tmp$nPerBin
        vlines <- tmp$vlines; xlimit <- tmp$xlimit; ylimit <- tmp$ylimit
        breaks <- tmp$breaks; wide <- tmp$wide; LOG <- tmp$LOG; POINTS <- F
        MEDIAN <- tmp$MEDIAN
        
        if(nhold > 0){
          add <- T
          log <- ''
          if(LOG)log <- 'xy'
          plot(y1[holdoutIndex,],yp[holdoutIndex,],xlab=' ',ylab=ylab,
               xlim=xlimit,ylim=ylimit,col='grey',pch=21,bg='grey',cex=.4,log=log)
        } 
        
        if(LOG){
          wn <- which(y1 > 0 & yp > 0)
          y1 <- y1[wn]
          yp <- yp[wn]
        }
            
        tmp <- .plotObsPred(y1,yp,xlabel='Observed',ylabel=ylab,nbin=nbin, nPerBin=nPerBin,
                           xlimit=xlimit,ylimit=ylimit,breaks=breaks,wide=wide,
                           LOG=LOG,fill='grey',POINTS=F,MEDIAN=MEDIAN,add=add)
        if(length(vlines) > 0)abline(v=vlines,lty=2)
        abline(0,1,lty=2)

        if(typeNames[wk[1]] != 'PA'){
          .gjamBaselineHist(y1,ylo=ylimit[1],nclass=20)
        } else {
          y11 <- mean(y1)
          y00 <- 1 - y11
          lines(c(-.02,-.02,.02,.02,.98,.98,1.02,1.02),
                c(0,y00,y00,0,0,y11,y11,0),type='s',lwd=2)
        }
        
        tf <- .gjamGetTypes(typeNames[wk[1]])$typeFull
        
        .plotLabel(tf,'topleft')
        abline(0,1,lty=2)
        abline(h = mean(y1),lty=2)
        if(k == 1).plotLabel('Predicted data',above=T,cex=1.2)
      }
    }
    readline('y vs predicted yMu -- return to continue')
    
  #  dev.copy2pdf(file=outFile(outfolder,'yPred.pdf')) 
  #  graphics.off()
  }
  
  if(PLOTX){
    
  # dev.new(width = width, height = height)
    npp <- ncol(x)
    nrr <- ceiling(sqrt(npp))
    par( mfrow=c(nrr,nrr), bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp )
    
    noplot <- c(1,grep(':',xnames))
    vnames <- xnames[-noplot]
    ylab <- 'Predicted'
    
    if(length(vnames) > 0){
    
      nrr <- ceiling(length(vnames)/ncolPlot) + 1
      
      if(nrr == 0)nrr <- 1
      
      missX <- missingIndex
      xmaxX <- apply(x,2,max,na.rm=T)
      
      k <- 0
      
      for(j in 2:Q){
        
        if(!xnames[j] %in% vnames)next
        if(k > 0)ylab <- 'Predicted'
        
        k <- k + 1
        
        x1 <- x[,j]
        x2 <- xpredMu[,j]
        if(nhold > 0){
          x1 <- x1[-holdoutIndex]
          x2 <- x2[-holdoutIndex]
        }
        
        .plotObsPred(x1,x2,nbin=10,xlabel='Observed',ylabel=ylab,
                    POINTS=F)
        if(nhold > 0)points(x[holdoutIndex,j],xpredMu[holdoutIndex,j],col='grey',cex=.3)
        
        if(length(missX) > 0){
          ww <- which(missX[,2] == j)
          if(length(ww) > 0){
            wz <- missX[ww,]
            if(!is.matrix(wz))wz <- matrix(wz,1)
            points(jitter(ww*0+xmaxX[j]),xpredMu[wz],cex=.6,col='blue')
          }
          
        }
        abline(0,1,lty=2)
        .plotLabel(xnames[j])
      }
      
      readline('x vs inverse predicted xpredMu -- return to continue ')
      
  #    dev.copy2pdf(file=outFile(outfolder,'xPred.pdf'))
  #    graphics.off()
    }
  }
    
  if(plotAllY){
    
  # dev.new(width = width, height = height)
    
    yy <- y
    o  <- 1:ncol(y)
    
    if(ncol(y) > 16){
      
      rmspe <- sqrt( colSums( (y[,notOther] - yMu[,notOther])^2 )/n )
      o <- order(rmspe)[1:9]
      yy <- y[,o]
    }
    
    nr <- floor(sqrt(ncol(yy))) 
    if(nr < 1)nr <- 1
    nc <- nr
    if(nr*nc < ncol(yy))nr <- nr + 1
    if(nr*nc < ncol(yy))nc <- nc + 1

    par(mfrow=c(nr,nc),bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp)
    
    k <- 0
    
    for(j in o){
      
      k <- k + 1
      
      y1 <- y[,j]
      y2 <-yMu[,j]
      
      tmp <- .gjamPlotPars(type=typeNames[k],y1,y2)
      y1 <- tmp$y1; yp <- tmp$yp; nbin <- tmp$nbin; nPerBin <- tmp$nPerBin
      vlines <- tmp$vlines; xlimit <- tmp$xlimit; ylimit <- tmp$ylimit
      breaks <- tmp$breaks; wide <- tmp$wide; LOG <- tmp$LOG; POINTS <- F
      MEDIAN <- tmp$MEDIAN
      
      if(nhold > 0){
        add <- T
        log <- ''
        if(LOG)log <- 'xy'
        plot(y1[holdoutIndex],y2[holdoutIndex],xlab=' ',ylab=ylab,
             xlim=xlimit,ylim=ylimit,col='grey',pch=21,bg='grey',cex=.4,log=log)
      } 
      
      if(LOG){
        wn <- which(y1 > 0 & yp > 0)
        y1 <- y1[wn]
        y2 <- y2[wn]
      }
      
      tmp <- .plotObsPred(y1,y2,xlabel='Observed',ylabel=ylab,nbin=nbin, nPerBin=nPerBin,
                         xlimit=xlimit,ylimit=ylimit,breaks=breaks,wide=wide,
                         LOG=LOG,fill='grey',POINTS=F,MEDIAN=MEDIAN,add=add)
      if(length(vlines) > 0)abline(v=vlines,lty=2)
      abline(0,1,lty=2)
      
      .plotLabel( paste(letters[k],') ',colnames(y)[k],sep=''),above=T )
      abline(0,1,lty=2)
      abline(h = mean(y2),lty=2)
    }
    
    readline('y vs predicted yMu by response -- return to continue ')
    
  #  dev.copy2pdf(file=outFile(outfolder,'yPredbySpec.pdf')) 
  #  graphics.off()
  }
  
  ##############traits
  
  if(TRAITS){
    
    yy <- traitMeanMat
    o  <- 1:ncol(yy)
    
    if(ncol(yy) > 16){
      
      rmspe <- sqrt( colSums( (traitMeanMat - tMu)^2 )/n )
      o <- order(rmspe)[1:9]
      yy <- traitMeanMat[,o]
    }
    
    nr <- floor(sqrt(ncol(yy))) 
    if(nr < 1)nr <- 1
    nc <- nr
    if(nr*nc < ncol(yy))nc <- nr + 1
    if(nr*nc < ncol(yy))nr <- nr + 1
    
  # dev.new(width = width, height = height)
    
    par(mfrow=c(nr,nc), bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp)
    k <- 0
    
    for(j in o){
      
      jname <- colnames(tMu)[j]
      if(!jname %in% traitPlot)next
      
      k <- k + 1
      
      td <- traitMeanMat[,jname]
      
      tjj   <- tMu[,j]
      wj <- which(colnames(tMuOrd) == jname)
      
      tmp <- .gjamPlotPars(type=traitTypes[j],td,tjj)
      y1 <- tmp$y1; yp <- tmp$yp; nbin <- tmp$nbin; nPerBin <- tmp$nPerBin
      vlines <- tmp$vlines; xlimit <- tmp$xlimit; ylimit <- tmp$ylimit
      breaks <- tmp$breaks; wide <- tmp$wide; LOG <- tmp$LOG; POINTS <- F
      MEDIAN <- tmp$MEDIAN
      
      if(nhold > 0){
        add <- T
        log <- ''
        if(LOG)log <- 'xy'
        plot(td[holdoutIndex],tjj[holdoutIndex],xlab=' ',ylab=ylab,
             xlim=xlimit,ylim=ylimit,col='grey',pch=21,bg='grey',cex=.4,log=log)
      } 
      
      tmp <- .plotObsPred(td,tjj,xlabel=' ',ylabel=ylab,nbin=nbin, nPerBin=nPerBin,
                         xlimit=xlimit,ylimit=ylimit,breaks=breaks,wide=wide,LOG=LOG,
                         fill='grey',
                         POINTS=F,MEDIAN=MEDIAN,add=add)
      if(length(vlines) > 0)abline(v=vlines,lty=2)
      abline(0,1,lty=2)
      abline(h=mean(td,na.rm=T),lty=2)
      
      .plotLabel( paste(letters[k],') ',.traitLabel(jname),sep=''),above=T )
    }
    
    readline('return to continue')
    
  #  dev.copy2pdf(file=outFile(outfolder,'traitPred.pdf')) 
  #  graphics.off()
  }
    
  ##############sensitivity
  
  wc <- c(1:ncol(chains$sensGibbs))
  wx <- grep(':',colnames(chains$sensGibbs))
  if(length(wx) > 0)wc <- wc[-wx]
  
  wx <- grep('intercept',colnames(chains$sensGibbs))
  if(length(wx) > 0)wc <- wc[-wx]
  
# dev.new(width = width, height = height)
  
  par(mfrow=c(1,2),bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp)
  
  tmp <- boxplot( chains$sensGibbs[,wc],xaxt='n',outline=F,
                  pars = list(boxwex = 0.5))
  abline(h=0,lwd=2,col='grey')
  
  dy <- .05*diff(par()$yaxp[1:2])
  text(1:length(wc),dy + tmp$stats[5,],tmp$names,srt=90,pos=4)
   .plotLabel('Sensitivity to X')        
  
  if(length(isFactor) > 0){
    wx <- grep('intercept',colnames(chains$sensGibbs))
    wb <- grep(':',colnames(chains$sensGibbs))
    if(length(wb) > 0)wx <- c(wx,wb)
    wb <- grep('X',colnames(chains$sensGibbs))
    if(length(wb) > 0)wx <- c(wx,wb)
    
    for(j in 1:length(isFactor))wx <- c(wx,grep(isFactor[j],colnames(chains$sensGibbs)))
    wc <- c(1:ncol(chains$sensGibbs))[-wx]
    if(length(wc) > 0){
      tmp <- boxplot( chains$sensGibbs[,wc],xaxt='n',outline=F,
                      pars = list(boxwex = 0.5))
      ymax <- par()$usr[4]
      abline(h=0,lwd=2,col='grey')
      dy <- .05*diff(par()$yaxp[1:2])
      tt <- tmp$stats[5,]
      ty <- dy + tt
      ty[ty > (ymax - dy)] <- tmp$stats[1,ty > (ymax - dy)] - dy
      text(c(1:length(wc))+.12,ty,tmp$names,srt=90,pos=4)
    }
  }
          
  readline('sensGibbs, sensitivity over full model -- return to continue ')
  
#  dev.copy2pdf(file=outFile(outfolder,'sensitivity.pdf'))
#  graphics.off()
  
  ######################  coefficients
  
  if(length(sigBeta) == 0)sigBeta <- c(1:ncol(chains$bgibbs))
  betaSigGibbs <- chains$bgibbs[,sigBeta]
 
  if(sdScale){
    for(j in 2:ncol(x)){
      ww <- grep(xnames[j],colnames(betaSigGibbs))
      betaSigGibbs[,ww] <- betaSigGibbs[,ww]*xSd[j]
    }
    for(j in 1:ncol(y)){
      ww <- grep(snames[j],colnames(betaSigGibbs))
      betaSigGibbs[,ww] <- betaSigGibbs[,ww]/ySd[j]
    }
  }
      
  nc    <- 0
  vnam  <- matrix( unlist( strsplit(colnames(betaSigGibbs),'_') ),ncol=2,byrow=T)
  
  if( length(which(is.finite(match(colnames(y),vnam[,1])))) > 0 )nc <- 1
  if( length(which(is.finite(match(colnames(y),vnam[,2])))) > 0 )nc <- 2
  
  ix <- 1
  if(nc == 1)ix <- 2
  xnam <- vnam[,ix]
  vnam <- vnam[,nc]
  
  vnames <- unique(vnam)
  xnam <- unique(xnam[xnam != 'intercept'])
  
  mp  <- length(xnam)/ncolPlot
  nrr <- ceiling(mp)
  
# dev.new(width = width*.5, height = height*.5)
  par(mfrow=c(nrr,ncolPlot), bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp)
  
  for(k in 1:length(xnam)){
    
    tname <- xnam[k]
    
    tmp <- .chains2density(betaSigGibbs,varName=tname)
    xt  <- tmp$x
    yt  <- tmp$y
    chainMat <- tmp$chainMat
    
    colF <- colorRampPalette(c('black','brown','orange'))
    cols <- colF(nrow(xt))
    
    snamek <- matrix( unlist(strsplit(colnames(chainMat),'_')),ncol=2,byrow=T)
    if(colnames(y)[[2]] %in% snamek[,1])nc <- 1
    if(colnames(y)[[2]] %in% snamek[,2])nc <- 2
    snamek <- snamek[,nc]
    
    nn <- nrow(chainMat)
    plot(0,0,xlim=c(0,(1.4*nn)),ylim=range(chainMat),xlab=' ',ylab=' ',cex=.01)
    
    for(j in 1:ncol(chainMat)){
      lines(chainMat[,j],col=cols[j])
      if(ncol(chainMat) < 15)text(nn,chainMat[nn,j],snamek[j],col=cols[j],pos=4)
      if(k == 1 & j == 1).plotLabel( paste('burnin =',burnin),
                                    location='topright' )
    }
    .plotLabel(label=paste(letters[k],') ',tname,sep=''),location='topleft',above=T)
    
    abline(h=0,lwd=4,col='white')
    abline(h=0,lty=2)
    
    if(ncol(chainMat) >= 15) text(nn,mean(par('usr')[3:4]),paste(ncol(chainMat),'spp'),pos=4)
  }
  readline('beta coefficient chains -- return to continue ')
#  dev.copy2pdf(file=outFile(outfolder,'betaChains.pdf'))
 # graphics.off()
  
  ######################### correlation chains, species at random
  
  corSigGibbs <- chains$rgibbs[,sigCor]
  
  ssg <- matrix( unlist( strsplit(sigCor,'_') ),ncol=2,byrow=T )[,1]
  
  tname <- sample(ssg[ssg != snames[1]],1)
  
  tmp   <- .chains2density(corSigGibbs,varName=tname)
  xt    <- tmp$x
  yt    <- tmp$y
  chainMat <- tmp$chainMat
  
  colF   <- colorRampPalette(c('black','brown','orange'))
  cols <- colF(nrow(xt))
  
  stk <- matrix( unlist(strsplit(colnames(chainMat),'_')),ncol=2,byrow=T)
  
  ws <- which(stk[,1] == stk[,2])
  if(length(ws) > 0){
    stk <- stk[-ws,]
    chainMat <- chainMat[,-ws]
  }
  
  if(!is.matrix(chainMat)){
    chainMat <- matrix(chainMat,ncol=1)
    colnames(chainMat) <- colnames(tmp$chainMat)[-ws]
    stk <- matrix(stk,1)
  }
  snamek <- stk[,1]
  
# dev.new(width = width, height = height)
  par(bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp)
  
  nn <- nrow(chainMat)
  plot(0,0,xlim=c(0,(1.4*nn)),ylim=range(chainMat),xlab=' ',ylab=' ',cex=.01)
  
  for(j in 1:ncol(chainMat)){
    lines(chainMat[,j],col=cols[j])
    if(ncol(chainMat) < 15)text(nn,chainMat[nn,j],snamek[j],col=cols[j],pos=4)
    if(j == 1).plotLabel( paste('burnin =',burnin),location='topright' )
  }
  .plotLabel(label=paste(letters[k],') ',tname,sep=''),location='topleft',above=T)
  
  abline(h=0,lwd=4,col='white')
  abline(h=0,lty=2)
  
  if(ncol(chainMat) >= 15) text(nn,mean(par('usr')[3:4]),paste(ncol(chainMat),'spp'),pos=4)
  
  readline('correlation chains for a random response variable -- return to continue ')
  
#  dev.copy2pdf(file=outFile(outfolder,'corChains.pdf'))
#  graphics.off()
  
  ############################### beta posteriors as boxes
  
  nc    <- 0
  vnam  <- matrix( unlist( strsplit(colnames(betaSigGibbs),'_') ),ncol=2,byrow=T)
  
  if( length(is.finite(match(colnames(y),vnam[,1]))) > 0 )nc <- 2
  if( length(is.finite(match(colnames(y),vnam[,2]))) > 0 )nc <- 1
  
  ix <- 1
  if(nc == 1)ix <- 2
  xnam <- vnam[,ix]
  vnam <- vnam[,nc]
  
 # vnames <- unique(vnam)

  for(j in 2:length(xnames)){

    wc <- which(xnam == xnames[j])
    if(length(wc) < 2)next
    
  # dev.new(width = width, height = height)
    par(mfrow=c(1,1),bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp)
    
    mat <- betaSigGibbs[,wc]
    ord <- order(apply(mat,2,mean),decreasing=T)
    tnam <- vnam[wc[ord]]
    ry   <- range(mat)
    ymin <- min(mat) - diff(ry)*.15
    ymax <- max(mat) + diff(ry)*.15
    
    tmp <- boxplot( mat[,ord],xaxt='n',outline=F,ylim=c(ymin,ymax))
    abline(h=0,lwd=2,col='grey')
    
    dy <- .05*diff(par()$yaxp[1:2])
    text(1:length(wc),dy + tmp$stats[5,],tnam,srt=70,pos=4,cex=.7)
    .plotLabel(paste('beta_',xnames[j],sep=''),above=T)        
    
    plab <- paste('beta_',xnames[j],'.pdf',sep='')
    
    readline('95% posterior -- return to continue ')
    
 #   dev.copy2pdf(file=outFile(outfolder,plab))
 #   graphics.off()
  }
  
  ############################### cor posteriors, random species
  
# dev.new(width = width, height = height)
  
  nss <- min(length(notOmit),4)

  ss <- sample(snames[notOmit],nss)
  
  .plotChainDensity(chains$rgibbs[,keepSC],vnames=ss,
                   xlab='Parameter value',ylab='Density')
  
  readline('posterior density for correlation matrix -- return to continue ')
  
 # dev.copy2pdf(file=outFile(outfolder,'corPost.pdf'))
 # graphics.off()
  
   ########### cluster analysis
  
  if(!CLUSTERPLOTS)return()
  
  covy <- cov(y[,notOmit])
  covx <- cov(x)
  
  bx   <- t(betaMu[,notOmit])%*%covx%*%betaMu[,notOmit]
  nclus <- max(3,round(S/5,0) )
  
# dev.new(width = width, height = height)
  par(mfrow=c(1,2), cex=.7, oma=oma, mar=mar, tcl= tcl, mgp=mgp)
  
  tmp <- .clusterPlot( dist = .cov2Dist(covy) ,main='',cex=.2,
                      ncluster=nclus, 
                      colCode=NULL)
  colCode <- tmp$colCode
  .plotLabel('Data, distance',above=T)
  
  tmp <- .clusterPlot( dist = .cov2Dist(bx) ,main='',cex=.2,
                      ncluster=nclus, 
                      colCode=colCode)
  .plotLabel('E matrix',above=T)
  
  readline('E based on responses to X -- return to continue ')
  
#  dev.copy2pdf(file=outFile(outfolder,'clusterDistance.pdf'))
#  graphics.off()
  
  ########### correlation analysis
  
# dev.new(width = width, height = height)
  par(mfrow=c(1,2),bty='n',cex=1, oma=oma, mar=mar, tcl= tcl, mgp=mgp)
  
  tmp <- .clusterPlot( dcor = corMu[notOmit,notOmit] ,main=' ',cex=.2,
                      ncluster=nclus, 
                      colCode=NULL)
  corder <- rev( tmp$corder )
  specOrder <- snames[notOmit[corder]]
  
  .plotLabel(expression( paste('a) Cluster on ',hat(bold(R)) )),above=T)
  
  knames <- snames[ snames %in% snames[notOmit] ]
                     
  tmp <- .invMatZero(chains$rgibbs[,keepSC],nsim=2000,specOrder,index=NULL)
  marIn <- tmp$inMarMat
  conIn <- tmp$inConMat
  
  sigCor <- c(nrow(marIn),nrow(conIn))/SM/(SM - 1)
  sigCor <- round(100*sigCor,0)
  names(sigCor) <- c('n_marIn','n_conIn')
  
  mor <- notOmit[corder]
  
  crr <- corMu[mor,mor]
  marIn[,1] <- match(marIn[,1],mor)
  marIn[,2] <- match(marIn[,2],mor)
  conIn[,1] <- match(conIn[,1],mor)
  conIn[,2] <- match(conIn[,2],mor)
  
  makeCR <- list('grey' = conIn,'white' = marIn)
  
  .corPlot(crr,slim=c(-1,1),makeColor=makeCR,plotScale=.5,
          PDIAG=T,corLines=corLines,
          textSize=1, widex = width, widey = height,new=F)
  
  ll <- paste(c('Marg Ind (grey) = ','Cond Ind (white) = '),
              sigCor,c('%','%'),sep='')
  legend('topright',ll,bty='n',cex=.6)
  .plotLabel(expression( paste('b) ',hat(bold(R)),'structure'  )),above=T)
  
  readline('posterior correlation for model -- return to continue')
  
 # dev.copy2pdf(file=outFile(outfolder,'residCorGrid.pdf'))
 # graphics.off()
  
  #################################### cluster Emat
  
# dev.new(width = width, height = height)
  par(mfrow=c(1,2),bty='n',cex=1, oma=oma, mar=mar, tcl= tcl, mgp=mgp)
  
  tmp <- .multivarEmat(chains$bgibbs[,keepBC],covx,snames,notOther)
  bm  <- tmp$bm
  whichZero <- tmp$whichZero
  
  clusterData <- .clusterPlot( dcor = bm ,main=' ',cex=1,
                      ncluster=nclus,textSize=.5)
  .plotLabel(expression( paste('a) Cluster on ',hat(bold(E)) )),above=T)
  
  cord    <- rev(clusterData$corder)
  dord    <- notOther[!notOther %in% omit][cord]
  
  tmp <- .multivarEmat(chains$bgibbs[,keepBC],covx,snames,notOther[cord])
  bm  <- tmp$bm
  whichZero <- tmp$whichZero
  
  makeCB <- list('grey' = whichZero)
  
  .corPlot(bm,slim=c(-1,1),makeColor=makeCB,PDIAG=T,
          corLines=corLines,cex=2,plotScale=.5,
          textSize=1.2, widex = width, widey = height,new=F)
  .plotLabel(expression( paste('b) ',hat(bold(E)),'structure'  )),above=T)
  
  readline('model-based response to X -- return to continue')
  
 # dev.copy2pdf(file=outFile(outfolder,'EclusterGrid.pdf'))
 # graphics.off()
  
  ################# resid and Egrid
  
# dev.new(width = width, height = height)
  par(mfrow=c(1,2), bty='n',new=F, oma=oma, mar=mar, tcl= tcl, mgp=mgp)
  
  .corPlot(crr,slim=c(-1,1),makeColor=makeCR,PDIAG=T,
          corLines=corLines,plotScale=.5,
          textSize=.6,LEGEND=F, widex = width, widey = height,new=F)
  .plotLabel(expression( paste('a) ',hat(bold(R)),' structure'  )),above=T)
  
  tmp <- .multivarEmat(chains$bgibbs[,keepBC],covx,snames,mor)
  bm  <- tmp$bm
  whichZero <- list('grey' = tmp$whichZero)
  
  .corPlot(bm,slim=c(-1,1),makeColor=whichZero,PDIAG=T,
          corLines=corLines,plotScale=.5,
          textSize=.6,cex=2, widex = width, widey = height,new=F)
  .plotLabel(expression( paste('b) ',hat(bold(E)),' structure'  )),above=T)
  
  readline('comparison (same order of responses) -- return to continue ')
  
 # dev.copy2pdf(file=outFile(outfolder,'R&EclusterGrid.pdf'))
 # graphics.off()
  
  ################# data vs E grid
  
# dev.new(width = width, height = height)
  par(mfrow=c(1,2),bty='n',cex=.7, oma=oma, mar=mar, tcl= tcl, mgp=mgp)
  
  ytmp <- y[,notOmit[mor]]
  cory <- cor(ytmp)
  
  tmp <- .corMatCI(cory,n)$sig
  tmp[upper.tri(tmp)] <- tmp[lower.tri(tmp)]
  wz  <- which(tmp == 1,arr.ind=T)
  makeColy <- list('grey' = wz )
  
  .corPlot(cory,slim=c(-1,1),makeColor=makeColy,PDIAG=T,
          corLines=corLines,plotScale=.5,
          specLabs=T,LEGEND=F, widex = width, widey = height,new=F)
  .plotLabel('a) Data correlation',location='topleft',cex=1.5)
  
  .corPlot(bm,slim=c(-1,1),makeColor=whichZero,PDIAG=T,
          corLines=corLines,plotScale=.5,
          specLabs=T, widex = width, widey = height,new=F)
  .plotLabel(expression( paste('b) Environment response correlation ',hat(bold(E)) )),location='topleft',cex=1.5)
  
  readline('raw data vs response to X -- return to continue ')
  
#  dev.copy2pdf(file=outFile(outfolder,'dataEgrid.pdf'))
#  graphics.off()
  
  #################### beta grid
  if(betaGrid){
    
  # dev.new(width = width, height = height)
    
    wo <- notOther[!notOther %in% omit]
    bb <- .processPars(chains$bgibbs,sigOnly=F)$summary
    
    bc <- matrix(bb[,1],Q,S)[-1,]
    bl <- matrix(bb[,3],Q,S)[-1,]
    bh <- matrix(bb[,4],Q,S)[-1,]
    
    bb <- betaMu[-1,wo]
    
    ord <- order(colSums(abs(bb)),decreasing=T)
    bb <- bb[,ord]
    bl <- bl[,ord]
    bh <- bh[,ord]
    
    white <- which(bl < 0 & bh > 0,arr.ind=T)
    
    makeColor <- list('white' = white )
    
    plotScale <- max(c(10,c(S,Q)/10))
    par(bty='n', oma=oma, mar=mar, tcl= tcl, mgp=mgp)
    
    ht <- nrow(bb)/ncol(bb)*width
    
    .corPlot(bb,slim=NULL,PDIAG=F,plotScale=plotScale,
            makeColor=makeColor,textSize=.7,
            corLines=T,tri='both',
            cex=.6,specLabs=T,squarePlot=T,LEGEND=T,
            widex=width,widey=ht,new=F)
    readline('beta ordered by response to X -- return to continue ')
    
 #   dev.copy2pdf(file=outFile(outfolder,'betaGrid.pdf'))
 #   graphics.off()
  }
  
  invisible( list(betaEstimates = bCoeffTable, corEstimates = rCoeffTable, 
                  richnessBySite = richnessBySite,
                  fit = fit, clusterData = clusterData) )
}
