% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc}
\alias{mcmc}
\title{Markov chain Monte Carlo inference}
\usage{
mcmc(x, N, model = c("gk", "gh"), logB = FALSE,
  get_log_prior = improper_uniform_log_density, theta0, Sigma0, t0 = 100,
  epsilon = 1e-06, silent = FALSE, plotEvery = 100)
}
\arguments{
\item{x}{Vector of observations.}

\item{N}{Number of MCMC steps to perform.}

\item{model}{Whether to fit g-and-k or g-and-h model.}

\item{logB}{When true, the second parameter is log(B) rather than B.}

\item{get_log_prior}{A function with one argument (corresponding to a vector of 4 parameters e.g. A,B,g,k) returning the log prior density. This should ensure the parameters are valid - i.e. return -Inf for invalid parameters - as the \code{mcmc} code will not check this.}

\item{theta0}{Vector of initial value for 4 parameters.}

\item{Sigma0}{MCMC proposal covariance matrix}

\item{t0}{Tuning parameter (number of initial iterations without adaptation).}

\item{epsilon}{Tuning parameter (weight given to identity matrix in covariance calculation).}

\item{silent}{When \code{FALSE} (the default) a progress bar and intermediate results plots are shown.}

\item{plotEvery}{How often to plot the results if \code{silent==FALSE}.}
}
\value{
Matrix whose rows are MCMC states: the initial state \code{theta0} and N subsequent states.
}
\description{
Markov chain Monte Carlo (MCMC) inference for the g-and-k or g-and-h distribution
}
\details{
\code{mcmc} performs Markov chain Monte Carlo inference for iid data from a g-and-k or g-and-h distribution, using the adaptive Metropolis algorithm of Haario et al (2001).
}
\examples{
set.seed(1)
x = rgk(10, A=3, B=1, g=2, k=0.5) ##An unusually small dataset for fast execution of this example
out = mcmc(x, N=1000, theta0=c(mean(x),sd(x),0,0), Sigma0=0.1*diag(4))
}
\references{
D. Prangle gk: An R package for the g-and-k and generalised g-and-h distributions, 2017.
H. Haario, E. Saksman, and J. Tamminen. An adaptive Metropolis algorithm. Bernoulli, 2001.
}
