% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gldrmCI.R
\name{gldrmCI}
\alias{gldrmCI}
\title{Confidence intervals for gldrm coefficients}
\usage{
gldrmCI(gldrmFit, term, test = c("Wald", "LRT", "Score"), level = 0.95,
  type = c("2-sided", "lb", "ub"), eps = 1e-10, maxiter = 100)
}
\arguments{
\item{gldrmFit}{A gldrm model fit. Must be an S3 object of class "gldrm",
returned from the \code{gldrm} function.}

\item{term}{Character string containing the name of the coefficient of interest.
The coefficient names are the names of the beta component of the fitted model
object. They can also be obtained from the printed model output. Usually the
names match the formula syntax, but can be more complicated for categorical
variables and interaction terms.}

\item{test}{Character string for the type confidence interval. Options are
"Wald", "LRT" (for likelihood ratio), and "Score".}

\item{level}{Confidence level of the interval. Should be between zero and one.}

\item{type}{Character string containing "2-sided" for a two-sided confidence interval,
"lb" for a lower bound, or "ub" for an upper bound.}

\item{eps}{Convergence threshold. Only applies for
\code{test = "LRT"} and \code{test = "Score"}.
Convergence is reached when likelihood ratio p-value is within \code{eps} of
the target p-value, based on the level of the test. For example, a two-sided
95\% confidence interval has target p-value of 0.025 for both the upper and
lower bounds. A 95\% confidence bound has target p-value 0.05.}

\item{maxiter}{The maximum number of bisection method iterations for likelihood
ratio intervals or bounds. For two-sided intervals, \code{maxiter} iterations
are allowed for each bound.}
}
\value{
An S3 object of class 'gldrmCI', which is a list of the following items.

\itemize{
\item \code{term} Coefficient name.
\item \code{test} Type of interval or bound - Wald or likelihood ratio.
\item \code{level} Confidence level.
\item \code{type} Type of interval or bound - two-sided, upper bound, or lower
bound.
\item \code{cilo}/\code{cihi} Upper and lower interval bounds. One one of the
two applies for confidence bounds.
\item \code{iterlo}/\code{iterhi} Number of bisection iterations used. Only
applies for likelihood ratio intervals and bounds.
\item \code{pvallo}/\code{pvalhi} For likelihood ratio intervals and bounds,
the p-value at convergence is reported.
\item \code{conv} Indicator for whether the confidence interval limit or bound
converged.
}
}
\description{
Calculates a Wald, likelihood ratio, or score confidence interval for a single gldrm
coefficient. Also calculates upper or lower confidence bounds. Wald confidence
intervals and bounds are calculated from the standard errors which are available
from the gldrm model fit. For likelihood ratio and score intervals and bounds,
a bisection search method is used, which takes longer to run.
}
\examples{
data(iris, package="datasets")

### Fit gldrm with all variables
fit <- gldrm(Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width + Species,
             data=iris, link="log")

### Wald 95\% confidence interval for Sepal.Width
ci <- gldrmCI(fit, "Sepal.Width", test="Wald", level=.95, type="2-sided")
ci

}
