% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glinvci.R
\name{varest}
\alias{varest}
\alias{varest.glinv}
\title{Estimate the variance-covariance matrix of the maximum likelihood estimator.}
\usage{
varest(mod, ...)

\method{varest}{glinv}(
  mod,
  fitted,
  method = "analytical",
  numDerivArgs = list(method = "Richardson", method.args = list(d = 0.5, r = 3)),
  store_gaussian_hessian = FALSE,
  control.mc = list(),
  ...
)
}
\arguments{
\item{mod}{An object of class \code{glinv}}

\item{...}{Not used.}

\item{fitted}{Either an object returned by \code{fit.glinv} or a vector of length \code{mod$nparams}
that contains the maximum likelihood estimate.}

\item{method}{Either `analytical', `linear' or `mc'. It specifies how the covariance matrix
is computed.}

\item{numDerivArgs}{Arguments to pass to \code{numDeriv::\link[numDeriv]{jacobian}}. Only used if the
user did not supply \code{parjacs} when constructing \code{mod}.}

\item{store_gaussian_hessian}{If \code{TRUE} and \code{method} is not \code{mc}, the returned list will contain
a (usually huge) Hessian matrix \code{gaussian_hessian} with respect to the Gaussian
parameters \eqn{\Phi, w, V'}. This option significantly increases the amount of memory
the function uses, in order to store the matrix.}

\item{control.mc}{A list of additional arguments to pass to the \code{mc} method.}
}
\value{
A list containing
                            \item{vcov}{The estimated variance-covariance matrix of the maximum likelihood estimator.}
                            \item{mlepar}{The maximum likelihood estimator passed in by the user.}
                            \item{hessian}{The Hessian of the log-likelihood at the maximum likelihood estimate. Only exists when \code{method} is not \code{mc}}
                            \item{gaussian_hessian}{Optional, only exists when `store_gaussian_hessian` is TRUE.}
}
\description{
\code{varest} estimates the uncertainty of an already-computed maximum likelihood estimate.
}
\details{
If \code{method} is \code{analytical} then the covariance matrix is estimated by inverting the
negative analytically-computed Hessian at the maximum likelihood estimate; if it is 
\code{mc} then the estimation is done by using Spall's Monte Carlo simultaneous perturbation method;
if it is \code{linear} then it is done by the "delta method", which approximates the user
parameterisation with its first-order Taylor expansion.

The \code{analytical} method requires that \code{parhess} was specified when `mod` was created.
The \code{linear} method does not use the curvature of the reparameterisation and its result is
sometimes unreliable; but it does not require the use of \code{parhess}. The \code{mc} method also
does not need \code{parjacs}, but the it introduces an additional source complexity and random noise
into the estimation; and a large number of sample may be needed.

The \code{control.mc} can have the following elements:
\describe{
    \item{Nsamp}{Integer. Number of Monte Carlo iteration to run. Default is 10000.}
    \item{c}{Numeric. Size of perturbation to the parameters. Default is 0.005.}
    \item{quiet}{Boolean. Whether to print progress and other information or not. Default is \code{TRUE}.}
}
}
\references{
Spall JC. Monte Carlo computation of the Fisher information matrix in nonstandard settings. Journal of Computational and Graphical Statistics. 2005 Dec 1;14(4):889-909.
}
