% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_options.R
\name{adaptControl}
\alias{adaptControl}
\title{Control of Metropolis-within-Gibbs Adaptive Random Walk Sampling Procedure

Controls the adaptive random walk Metropolis-within-Gibbs sampling procedure.}
\usage{
adaptControl(batch_length = 100, offset = 0)
}
\arguments{
\item{batch_length}{positive integer specifying the number of posterior samples to collect
before the proposal variance is adjusted based on the acceptance rate of the last 
\code{batch_length} accepted posterior samples. Default is set to 100. Batch length restricted
to be no less than 50.}

\item{offset}{non-negative integer specifying an offset value for the increment of the proposal
variance adjustment. Optionally used to ensure the required diminishing adaptation condition. 
Default set to 0.
\verb{
increment = min(0.01, 1 / sqrt(batch*batch_length + offset))
}}
}
\value{
Function returns a list (inheriting from class "\code{adaptControl}") 
containing parameter specifications for the adaptive random walk sampling procedure.
}
\description{
Control of Metropolis-within-Gibbs Adaptive Random Walk Sampling Procedure

Controls the adaptive random walk Metropolis-within-Gibbs sampling procedure.
}
