% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{ranef.glmmTMB}
\alias{ranef.glmmTMB}
\alias{ranef}
\title{Extract Random Effects}
\usage{
\method{ranef}{glmmTMB}(object, ...)
}
\arguments{
\item{object}{a \code{glmmTMB} model.}

\item{...}{some methods for this generic function require additional
arguments.}
}
\value{
Object of class \code{ranef.glmmTMB} with two components:
  \item{conditional_model}{a list of data frames, containing random effects
    for the conditional model.}
  \item{zero_inflation}{a list of data frames, containing random effects for
    the zero inflation.}
}
\description{
Generic function to extract random effects from \code{glmmTMB} models, both
for the conditional model and zero inflation.
}
\note{
When a model has no zero inflation, the default behavior of
  \code{ranef} is to simplify the printed format of the random effects. To
  show the full list structure, run \code{print(ranef(model),
  simplify=FALSE)}. In all cases, the full list structure is used to access
  the data frames (see example).
}
\examples{
data(sleepstudy, package="lme4")
model <- glmmTMB(Reaction ~ Days + (1|Subject), sleepstudy)
ranef(model)
print(ranef(model), simplify=FALSE)
ranef(model)$conditional_model$Subject

}
\seealso{
\code{\link{fixef.glmmTMB}}.
}
