% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_ci.R
\name{combine_resampled_lists}
\alias{combine_resampled_lists}
\title{Combines output from multiple bootstrap_model calls}
\usage{
combine_resampled_lists(..., return_combined_list = FALSE)
}
\arguments{
\item{...}{List of outputs to be combined, or just a bunch of output entries
as separate unnamed arguments.}

\item{return_combined_list}{Logical, default \code{FALSE}.
\code{TRUE} if you want the combined list of lists,
\code{FALSE} for just the output from bootstrap_ci applied to it.}
}
\value{
Returns the same output as \code{bootstrap_ci} by default,
  or the combined list (as if you had just run bootstrap_model once with
  all resamples) if \code{return_combined_list = TRUE}
}
\description{
If you run glmmboot on e.g. a grid of computers,
set \code{return_coefs_instead = TRUE} for each.
Then enter them all here. Either just list them out,
or put them into one list and enter them.
}
\examples{
\donttest{
  data(test_data)
  library(glmmTMB)
  ## where subj is some RE
  test_model <- glmmTMB(y ~ x_var1 + (1 | subj),
                        data = test_data,
                        family = binomial)
  output_list1 <- bootstrap_model(
      test_model, base_data = test_data, 99, return_coefs_instead = TRUE)
  output_list2 <- bootstrap_model(
      test_model, base_data = test_data, 100, return_coefs_instead = TRUE)
  output_list3 <- bootstrap_model(
      test_model, base_data = test_data, 100, return_coefs_instead = TRUE)
  combine_resampled_lists(output_list1, output_list2, output_list3)

  num_blocks = 10
  num_total_resamples = 299
  reg_list <- list()
  for(i in 1:num_blocks){
      if(i < num_blocks){
          block_resamples = floor((num_total_resamples + 1)/num_blocks)
      } else {
          block_resamples = floor((num_total_resamples + 1)/num_blocks - 1)
      }
      reg_list[[i]] = bootstrap_model(test_model,
                                      base_data = test_data,
                                      resamples = block_resamples,
                                      return_coefs_instead = TRUE,
                                      num_cores = 1) ## increase for parallel
  }
  boot_ci1 <- combine_resampled_lists(reg_list)
  full_list <- combine_resampled_lists(reg_list, return_combined_list = TRUE)
  boot_ci2 <- bootstrap_ci(full_list$base_coef_se,
                           full_list$resampled_coef_se)
  identical(boot_ci1, boot_ci2)
}

}
