% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.glmnetr_240224.R
\name{plot.glmnetr}
\alias{plot.glmnetr}
\title{Plot the relaxed lasso coefficients.}
\usage{
\method{plot}{glmnetr}(x, gam = NULL, lambda.lo = NULL, title = NULL, comment = TRUE, ...)
}
\arguments{
\item{x}{Either a glmnetr, cv.glmnetr or a nested.glmnetr output object.}

\item{gam}{A specific level of gamma for plotting.  By default gamma.min from
the deviance minimizing (lambda.min, gamma.min) pair will be used.}

\item{lambda.lo}{A lower limit of lambda for plotting.}

\item{title}{A title for the plot}

\item{comment}{Default of TRUE to write to console information on lam and gam selected for output.
FALSE will suppress this write to console.}

\item{...}{Additional arguments passed to the plot function.}
}
\value{
This program returns a plot to the graphics window, and may provide 
some numerical information to the R Console.  If the input object is from a
nested.glmnetr or cv.glmnetr object, and gamma is not specified, 
then the gamma.min from
the deviance minimizing (lambda.min, gamma.min) pair will be used, and the
minimizing lambda.min will be indicated by a vertical line.  Also, if one 
specifies gam=0, the lambda which minimizes deviance for the restricted 
set of models where gamma=0 will indicated by a vertical line.
}
\description{
Plot the relaxed lasso coefficients from either a glmnetr(), cv.glmnetr() or nested.glmnetr() output object.
One may specify gam, single value for gamma.  If gam is unspecified (NULL), then cv.glmnetr and 
nested.glmnetr() will use the gam which minimizes loss, and glmentr() will use gam=1.
}
\examples{
\donttest{
set.seed(82545037)
sim.data=glmnetr.simdata(nrows=200, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$yt
event=sim.data$event
glmnetr.fit = glmnetr( xs, NULL, y_, event, family="cox")
plot(glmnetr.fit)
}

}
\seealso{
\code{\link{plot.cv.glmnetr}} , \code{\link{plot.nested.glmnetr}} , \code{\link{glmnetr}}
}
