% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gau_data}
\alias{gau_data}
\title{A simulated gaussian dataset.}
\format{
A list with five elements: design matrix \code{X}, response \code{y}, 
  correlation structure of the covariates \code{Sigma}, true beta \code{beta}, 
  and the noise level \code{sigma}.
\describe{
  \item{X}{design matrix}
  \item{y}{response}
  \item{Sigma}{correlation matrix of the covariates}
  \item{beta}{true beta values}
  \item{sigma}{the noise level}
  ...
}
}
\usage{
data(gau_data)
}
\description{
A dataset simulated for illustrating linear regression models.
}
\examples{
data("gau_data")
cv.fit <- cv.glmtlp(gau_data$X, gau_data$y, family = "gaussian", penalty = "tlp")
plot(cv.fit)

}
\keyword{datasets}
