% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genDiag.R
\name{predict.genDiag}
\alias{predict.genDiag}
\title{Predict method for generalised diagonalisation objects}
\usage{
\method{predict}{genDiag}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{a generalized diagonalisation object, as obtained from a call to
\code{\link{Maf}}, and on the same page, information on the other diagonalisation
methods \code{UWEDGE} or \code{RJD}}

\item{newdata}{a matrix or data.frame of factor scores to convert back to the original
scale (default: the scores element from \code{object})}

\item{...}{not used, kept for generic compatibility}
}
\value{
A data set or compositional object of the nature of the original data
used for creating the genDiag object.
}
\description{
Predict method for generalised diagonalisation objects
}
\examples{
data("jura", package="gstat")
juracomp = compositions::acomp(jura.pred[, -(1:6)]) 
lrvg = logratioVariogram(data=juracomp, loc=jura.pred[,1:2])
mf = Maf(juracomp, vg=lrvg)
mf
biplot(mf)
predict(mf) 
unclass(predict(mf)) - unclass(juracomp) # predict recovers the original composition
}
\seealso{
Other generalised Diagonalisations: 
\code{\link{Maf}()},
\code{\link{coloredBiplot.genDiag}()}
}
\concept{generalised Diagonalisations}
