% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmDataFrameStack.R
\name{stackDim}
\alias{stackDim}
\alias{stackDim.DataFrameStack}
\alias{noStackDim}
\alias{noStackDim.default}
\alias{stackDim<-}
\alias{stackDim<-.default}
\title{Get/set name/index of (non)stacking dimensions}
\usage{
stackDim(x, ...)

\method{stackDim}{DataFrameStack}(x, ...)

noStackDim(x, ...)

\method{noStackDim}{default}(x, ...)

stackDim(x) <- value

\method{stackDim}{default}(x) <- value
}
\arguments{
\item{x}{a \code{\link[=DataFrameStack]{DataFrameStack()}} object, (only for \code{stackDim} it can also be a \code{Spatial}
object which \code{data} slot is a \code{DataFrameStack})}

\item{...}{extra arguments for generic functionality}

\item{value}{the name or the index to be considered as stacking dimension}
}
\value{
the index or the name of the asked dimension.
}
\description{
Return (or set) the name or index of either the stacking dimension, or else of the
non-stacking dimension (typically, the dimension runing through the variables)
}
\section{Functions}{
\itemize{
\item \code{stackDim.DataFrameStack}: Get/set name/index of (non)stacking dimensions

\item \code{noStackDim}: Get/set name/index of (non)stacking dimensions

\item \code{noStackDim.default}: Get/set name/index of (non)stacking dimensions

\item \code{stackDim<-}: Get/set name/index of (non)stacking dimensions

\item \code{stackDim<-.default}: Get/set name/index of (non)stacking dimensions
}}

\examples{
ar = array(1:30, dim = c(5,2,3), dimnames=list(obs=1:5, vars=c("A","B"), rep=1:3))
dfs = DataFrameStack(ar, stackDim="rep")
dfs
stackDim(dfs)
noStackDim(dfs)
getStackElement(dfs, 1)
stackDim(dfs) <- "vars"
getStackElement(dfs, 1)
}
