% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{getTellus}
\alias{getTellus}
\title{Download the Tellus survey data set (NI)}
\usage{
getTellus(wd = ".", destfile = "TellusASoil.RData", TI = FALSE, cleanup = TRUE)
}
\arguments{
\item{wd}{working directory, where intermediate files and output will be produced}

\item{destfile}{file name where to put the Tellus data (including the extension ".Rdata"!)}

\item{TI}{either a logical (should the training image be created? defaults to FALSE) or
else the file name where to put the created training image (including the extension ".Rdata")}

\item{cleanup}{should the downloaded excel file be removed? defaults to TRUE}
}
\value{
TRUE if everything went OK. The function is actually called for the
side effect of downloading data from the Tellus survey project website, so be careful
to call it specifying the right directory at \code{wd}.
}
\description{
Download the A-soil geochemistry data of the Tellus survey (Northern Ireland),
and if desired produce a training image of the geochemical subcomposition
Mg-Al-Ca-Fe-Rest.
}
\details{
The function is provided due to conflicting licenses. You download the
data from the server \url{https://www.bgs.ac.uk/gsni/tellus/index.html} at your own
accord. Actually a visit to the project data webpage is highly recommended, in particular
for learning about the QA/QC process of the data acquisition, other data sources
available and how to use this wealth of data.
}
\section{Geochemical soil A survey}{


The function will download an excel file to your working directory, do some
manipulations, save the resulting data.frame in a "TellusASoil.RData" file (or any other
name you provide on the \code{destfile} argument) and
eventually, remove the excel file (if you left \code{cleanup=TRUE}). This data set has
6862 obervations and 58 variables:
\describe{
\item{Sample}{Sample ID}
\item{EASTING}{X coordinate of each point}
\item{NORTHING}{Y coordinate of each point}
\item{Flag}{a flag marking some data as a study subset, fixed for reproducibility}
\item{Ag}{Silver concentration in \code{ppm}}
\item{Cd}{Cadmium concentration in \code{ppm}}
\item{In}{Indium concentration in \code{ppm}}
\item{Sn}{Tin concentration in \code{ppm}}
\item{Sb}{Antimony concentration in \code{ppm}}
\item{Te}{Tellurium concentration in \code{ppm}}
\item{I}{Indim concentration in \code{ppm}}
\item{Cs}{Caesium concentration in \code{ppm}}
\item{Ba}{Barium concentration in \code{ppm}}
\item{La}{Lanthanum concentration in \code{ppm}}
\item{Ce}{Cerium concentration in \code{ppm}}
\item{Na2O}{Sodium oxide in \code{percent}}
\item{MgO}{Magnesium oxide in \code{percent}}
\item{Al2O3}{Aluminium oxide in \code{percent}}
\item{SiO2}{Silicium oxide in \code{percent}}
\item{P2O5}{Phosphorous(V) oxide in \code{percent}}
\item{SO3}{Sulphur(III) oxide in \code{percent}}
\item{K2O}{Potasium oxide in \code{percent}}
\item{CaO}{Calcium oxide in \code{percent}}
\item{TiO2}{Titanium oxide in \code{percent}}
\item{MnO}{Manganese oxide in \code{percent}}
\item{Fe2O3}{Total Iron(III) oxide in \code{percent}}
\item{Cl}{Chlorine concentration in \code{ppm}}
\item{Sc}{Scandium concentration in \code{ppm}}
\item{V}{Vanadium concentration in \code{ppm}}
\item{Cr}{Chromium concentration in \code{ppm}}
\item{Co}{Cobalt concentration in \code{ppm}}
\item{Ni}{Nickel concentration in \code{ppm}}
\item{Cu}{Copper concentration in \code{ppm}}
\item{Zn}{Zinc concentration in \code{ppm}}
\item{Ga}{Callium concentration in \code{ppm}}
\item{Ge}{Germanium concentration in \code{ppm}}
\item{As}{Arsenic concentration in \code{ppm}}
\item{Se}{Selenium concentration in \code{ppm}}
\item{Br}{Bromine concentration in \code{ppm}}
\item{Rb}{Rubidium concentration in \code{ppm}}
\item{Sr}{Strontium concentration in \code{ppm}}
\item{Y}{Yttrium concentration in \code{ppm}}
\item{Zr}{Zirconium concentration in \code{ppm}}
\item{Nb}{Niobium concentration in \code{ppm}}
\item{Mo}{Molybdenum concentration in \code{ppm}}
\item{Nd}{Neodymium concentration in \code{ppm}}
\item{Sm}{Samarium concentration in \code{ppm}}
\item{Yb}{Ytterbium concentration in \code{ppm}}
\item{Hf}{Hafnium concentration in \code{ppm}}
\item{Ta}{Tantalum concentration in \code{ppm}}
\item{W}{Tungsten concentration in \code{ppm}}
\item{Tl}{Thallium concentration in \code{ppm}}
\item{Pb}{Lead concentration in \code{ppm}}
\item{Bi}{Bismuth concentration in \code{ppm}}
\item{Th}{Thorium concentration in \code{ppm}}
\item{U}{Uranium concentration in \code{ppm}}
\item{pH}{soil acidity}
\item{LOI}{loss on ignition in \code{percent}}
}
}

\section{Training image}{
 Additionally, if you give \code{TI!=FALSE},
the function will produce an additional
file "Tellus_TI.RData" (if \code{TI=TRUE}, or any other filename that you
specify on the argument \code{TI}) with a data.frame with 13287 rows and 8 columns:
\describe{
\item{EASTING}{X coordinate of each cell point}
\item{NORTHING}{Y coordinate of each cell point}
\item{MgO}{Magnesia proportion}
\item{Al2O3}{Alumina proportion}
\item{CaO}{Calcium oxide proportion}
\item{Fe2O3}{Iron oxide proportion}
\item{Rest}{Residual complementing the sum to 1}
\item{Mask}{Indicator of grid point outside the boundary of the country.
NOTE: to use it with \code{\link[=setMask]{setMask()}} you will need to invert it using \code{!as.logical(TellusTI$Mask)}}
}
This is a migrated version of the data set to a regular grid, ideal for illustrating
and testing multiple point geostatistical algorithms.
}

\examples{
\dontrun{
 getwd()
 getTellus(TI=TRUE, cleanup=TRUE)
 dir(pattern="Tellus")
}
}
\references{
\url{https://www.bgs.ac.uk/gsni/tellus/index.html}
}
