% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmSpatialMethodParameters.R
\name{KrigingNeighbourhood}
\alias{KrigingNeighbourhood}
\title{Create a parameter set of local for neighbourhood specification.}
\usage{
KrigingNeighbourhood(
  nmax = Inf,
  nmin = 0,
  omax = 0,
  maxdist = Inf,
  force = FALSE,
  anisotropy = NULL,
  ...
)
}
\arguments{
\item{nmax}{maximum number of data points per cokriging system}

\item{nmin}{minimum number of data points per cokriging system}

\item{omax}{maximum number of data points per cokriging system per quadrant/octant}

\item{maxdist}{maximum radius of the search neighborhood}

\item{force}{logical; if less than \code{nmin} points are found inside \code{maxdist} radius,
keep searching.}

\item{anisotropy}{currently ignored; in the future, argument to specify anisotropic search areas.}

\item{...}{further arguments, currently ignored}
}
\value{
an S3-list of class "gmKrigingNeighbourhood" containing the six elements given as arguments
to the function. This is just a compact way to provide further functions such as \link{predict_gmSpatialModel}
with appropriate triggers for choosing a prediction method or another, in this case for triggering
cokriging (if alone) or eventually sequential simulation (see \code{\link[=SequentialSimulation]{SequentialSimulation()}}).
}
\description{
Create a parameter set describing a kriging neighbourhood (local or global) for
cokriging and cokriging based simulation. This heavily relies on the definitions of
\code{\link[gstat:gstat]{gstat::gstat()}}. All parameters are optional, as their default amounts to a global
neihghbourhood.
}
\examples{
data("jura", package="gstat")
X = jura.pred[,1:2]
summary(X)
Zc = jura.pred[,7:10]
ng_global = KrigingNeighbourhood()
ng_local = KrigingNeighbourhood(maxdist=1, nmin=4, 
                                omax=5, force=TRUE)
ng_local
ng_global
make.gmCompositionalGaussianSpatialModel(data = Zc, coords = X,
                                         V = "alr", ng = ng_local)
}
