% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rgraph}
\alias{rgraph}
\title{Random generation of acyclic digraphs and undirected graphs}
\usage{
rgraph(p, d, dag = FALSE, ordered = TRUE)
}
\arguments{
\item{p}{Number of vertices of the sampled graph.}

\item{d}{Proportion of edges in the generated graph.}

\item{dag}{Whether the generated graph should be acyclic directed.}

\item{ordered}{When generating an acyclic directed graph, whether the nodes
should follow the ancestral order \code{1, ..., p}.}
}
\value{
The generated graph.
}
\description{
Wrapper of functionality from package \code{igraph} for random generation of
graphs.
}
\details{
When \code{dag = FALSE}, the graph is sampled from an Erdos-Renyi model.
In the case where \code{dag = TRUE}, the upper triangle of the adjacency matrix of
an Erdos-Renyi model is taken as the adjacency matrix for the acyclic
digraph. This preserves the proportion of edges \code{d}.
}
\examples{
## Random undirected graph with 3 nodes and 50\% density of edges
rgraph(p = 3, d = 0.5)

## Random directed acyclic graphs
# Following the natural ancestral order 1, ..., p
dag <- rgraph(p = 6, d = 0.5, dag = TRUE)
igraph::topo_sort(dag)

# Following a random ancestral order
dag <- rgraph(p = 6, d = 0.5, dag = TRUE, ordered = FALSE)
igraph::topo_sort(dag)
}
