% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMVARconstruction.R
\name{reorder_W_columns}
\alias{reorder_W_columns}
\title{Reorder columns of the W-matrix and lambda parameters of a structural GMVAR, StMVAR, or G-StMVAR model.}
\usage{
reorder_W_columns(gsmvar, perm)
}
\arguments{
\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{perm}{an integer vector of length \eqn{d} specifying the new order of the columns of \eqn{W}.
Also lambda parameters of each regime will be reordered accordingly.}
}
\value{
Returns an object of class \code{'gsmvar'} defining a structural GMVAR, StMVAR, or G-StMVAR model with the modified
  structural parameters and constraints.
}
\description{
\code{reorder_W_columns} reorder columns of the W-matrix and lambda parameters
  of a structural GMVAR, StMVAR, or G-StMVAR model.
}
\details{
The order of the columns of \eqn{W} can be changed without changing the implied reduced
  form model as long as the order of lambda parameters is also changed accordingly. Note that the
  constraints imposed on \eqn{W} (or the B-matrix) will also be modified accordingly.

  This function does not support models with constraints imposed on the lambda parameters!

  Also all signs in any column of \eqn{W} can be swapped (without changing the implied reduced form model)
  with the function \code{swap_W_signs} but this obviously also swaps the sign constraints in the
  corresponding columns of \eqn{W}.
}
\examples{
# Structural GMVAR(2, 2), d=2 model identified with sign-constraints:
params22s <- c(0.36, 0.121, 0.484, 0.072, 0.223, 0.059, -0.151, 0.395,
  0.406, -0.005, 0.083, 0.299, 0.218, 0.02, -0.119, 0.722, 0.093, 0.032,
  0.044, 0.191, 0.057, 0.172, -0.46, 0.016, 3.518, 5.154, 0.58)
W_22 <- matrix(c(1, 1, -1, 1), nrow=2, byrow=FALSE)
mod22s <- GSMVAR(p=2, M=2, d=2, params=params22s, structural_pars=list(W=W_22))
mod22s

# The same reduced form model, reordered W and lambda in the structual model:
mod22s_2 <- reorder_W_columns(mod22s, perm=2:1)
mod22s_2

# Structural StMVAR(2, 2), d=2 model identified with sign-constraints:
mod22ts <- GSMVAR(p=2, M=2, d=2, params=c(params22s, 10, 20), model="StMVAR",
                 structural_pars=list(W=W_22))
mod22ts

# The same reduced form model, reordered W and lambda in the structual model:
mod22ts_2 <- reorder_W_columns(mod22ts, perm=2:1)
mod22ts_2
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
   \item Virolainen S. 2021. Gaussian and Student's t mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2109.13648.
 }
 @keywords internal
}
\seealso{
\code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link{GIRF}}, \code{\link{gsmvar_to_sgsmvar}},
 \code{\link{stmvar_to_gstmvar}}, \code{\link{swap_W_signs}}
}
