% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMVARconstruction.R
\name{swap_W_signs}
\alias{swap_W_signs}
\title{Swap all signs in pointed columns a the \eqn{W} matrix of a structural GMVAR, StMVAR, or G-StMVAR model.}
\usage{
swap_W_signs(gsmvar, which_to_swap)
}
\arguments{
\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{which_to_swap}{a numeric vector of length at most \eqn{d} and elemnts in \eqn{1,..,d}
specifying the columns of \eqn{W} whose sign should be swapped.}
}
\value{
Returns an object of class \code{'gsmvar'} defining a structural GMVAR, StMVAR, or G-StMVAR model with the modified
  structural parameters and constraints.
}
\description{
\code{swap_W_signs} swaps all signs in pointed columns a the \eqn{W} matrix
 of a structural GMVAR, StMVAR, or G-StMVAR model. Consequently, signs in the columns of the B-matrix are also swapped
 accordingly.
}
\details{
All signs in any column of \eqn{W} can be swapped without changing the implied reduced form model.
  Consequently, also the signs in the columns of the B-matrix are swapped. Note that the sign constraints
  imposed on \eqn{W} (or the B-matrix) are also swapped in the corresponding columns accordingly.

  Also the order of the columns of \eqn{W} can be changed (without changing the implied reduced
  form model) as long as the order of lambda parameters is also changed accordingly. This can be
  done with the function \code{reorder_W_columns}.
}
\examples{
# Structural GMVAR(2, 2), d=2 model identified with sign-constraints:
params22s <- c(0.36, 0.121, 0.484, 0.072, 0.223, 0.059, -0.151, 0.395,
  0.406, -0.005, 0.083, 0.299, 0.218, 0.02, -0.119, 0.722, 0.093, 0.032,
  0.044, 0.191, 0.057, 0.172, -0.46, 0.016, 3.518, 5.154, 0.58)
W_22 <- matrix(c(1, 1, -1, 1), nrow=2, byrow=FALSE)
mod22s <- GSMVAR(p=2, M=2, d=2, params=params22s, structural_pars=list(W=W_22))
mod22s

# The same reduced form model, with signs in the second column of W swapped:
swap_W_signs(mod22s, which_to_swap=2)

# The same reduced form model, with signs in both column of W swapped:
swap_W_signs(mod22s, which_to_swap=1:2)

#' # Structural G-StMVAR(2, 1, 1), d=2 model identified with sign-constraints:
mod22gss <- GSMVAR(p=2, M=c(1, 1), d=2, params=c(params22s, 10), model="G-StMVAR",
                   structural_pars=list(W=W_22))
mod22gss

# The same reduced form model, with signs in the first column of W swapped:
swap_W_signs(mod22gss, which_to_swap=1)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2022. Structural Gaussian mixture vector autoregressive model with application to the asymmetric
     effects of monetary policy shocks. Unpublished working paper, available as arXiv:2007.04713.
   \item Virolainen S. 2022. Gaussian and Student's t mixture vector autoregressive model with application to the
     asymmetric effects of monetary policy shocks in the Euro area. Unpublished working
     paper, available as arXiv:2109.13648.
 }
 @keywords internal
}
\seealso{
\code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link{GIRF}}, \code{\link{reorder_W_columns}},
 \code{\link{gsmvar_to_sgsmvar}}, \code{\link{stmvar_to_gstmvar}}
}
