% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootAUC.R
\name{bootAUC}
\alias{bootAUC}
\title{Obtain bootstrapped area under the curve measures for a joint model.}
\usage{
bootAUC(
  fit,
  data,
  Tstart,
  delta,
  boot.size = NULL,
  nboot = 100,
  replace = TRUE,
  ci = 0.95,
  nsim = 0,
  progress = TRUE,
  control = list()
)
}
\arguments{
\item{fit}{a joint model fit by the  \code{joint} function.}

\item{data}{the data to which the original \code{joint} model was fit.}

\item{Tstart}{The start of the time window of interest, \code{Tstart} denotes the time
point up to which longitudinal process(es) is used in calculation of survival probabilities.}

\item{delta}{scalar denoting the length of time interval to check for failure times.}

\item{boot.size}{the number of samples to take from the data. Default value is \code{NULL}
which uses the number of distinct \code{ids} in the \code{data}.}

\item{nboot}{the number of bootstrap replicates upon which the summaries are formed.}

\item{replace}{logical, can \code{id}s be randomly sampled more than once? Defaults to
\code{replace = TRUE}.}

\item{ci}{confidence interval to be returned on AUC estimates, defaults to 
\code{ci = 0.95} which produces a 95\% confidence interval.}

\item{nsim}{number of simulations to use in each call to \code{\link{dynPred}},
defaults to \code{nsim=0} which results in first-order estimates being used.}

\item{progress}{logical, should a progress bar showing the percentage of completed
bootstrapped estimates? Defauts to \code{progress=TRUE}.}

\item{control}{list of control arguments to pass to \code{\link{dynPred}} via 
\code{\link{ROC}}, these largely control the MC simulation scheme. Note the user
shouldn't specify the number of  simulations here as well, as this is covered 
by the argument \code{nsim}.}
}
\value{
a list of class \code{bootAUC.joint} containing relevant summary information,
items of interest from each call to \code{\link{ROC}} and bootstrapping settings.
}
\description{
Compute summary for the area under the curve of a joint model fit
given a set of data and a time-window of interest by bootstrapping.
}
\examples{
\donttest{
data(PBC)
PBC$serBilir <- log(PBC$serBilir)
long.formulas <- list(serBilir ~ drug * time + (1 + time|id))
surv.formula <- Surv(survtime, status) ~ drug
family <- list('gaussian')
fit <- joint(long.formulas, surv.formula, PBC, family)
# 100 first order estimates in window (8, 9]
AUCs <- bootAUC(fit, PBC, Tstart = 8, delta = 1)
AUCs
}
}
\seealso{
\code{\link{bootAUCdiff}}, \code{\link{dynPred}} and \code{\link{ROC}}.
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk}).
}
