% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_words.R
\name{filter_words}
\alias{filter_words}
\title{Remove Words Below a Threshold from a TermDocumentMatrix/DocumentTermMatrix}
\usage{
filter_words(x, min = 1)
}
\arguments{
\item{x}{A \code{\link[tm]{TermDocumentMatrix}} or \code{\link[tm]{DocumentTermMatrix}}.}

\item{min}{A minimal threshold that a words row/column must sum to.}
}
\value{
Returns a \code{\link[tm]{TermDocumentMatrix}} or \code{\link[tm]{DocumentTermMatrix}}.
}
\description{
Remove words from a \code{\link[tm]{TermDocumentMatrix}}
or \code{\link[tm]{DocumentTermMatrix}} not meeting a \code{\link[base]{rowSums}}/
\code{\link[base]{colSums}} threshold.
}
\examples{
(x <-with(presidential_debates_2012, q_dtm(dialogue, paste(time, tot, sep = "_"))))
filter_words(x)
filter_words(x, 5)
(y <- with(presidential_debates_2012, q_tdm(dialogue, paste(time, tot, sep = "_"))))
filter_words(y, 6)
}
