% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios-fr.R
\name{elem-flmfr}
\alias{elem-flmfr}
\alias{r_cm2013_flmfr}
\alias{r_ik2018_flmfr}
\alias{r_gof2021_flmfr}
\title{Covariate, error, and kernel of a functional linear model
with functional response}
\usage{
r_cm2013_flmfr(n, s = seq(0, 1, len = 101), t = seq(0, 1, len = 101),
  std_error = 0.15, n_fpc = 50, concurrent = FALSE)

r_ik2018_flmfr(n, s = seq(0, 1, l = 101), t = seq(0, 1, l = 101),
  std_error = 1.5, parameters = c(1.75, 0.8, 2.4, 0.25), n_fpc = 50,
  concurrent = FALSE)

r_gof2021_flmfr(n, s = seq(0, 1, len = 101), t = seq(0, 1, len = 101),
  std_error = 0.35, concurrent = FALSE)
}
\arguments{
\item{n}{number of trajectories to sample.}

\item{s, t}{grid points where functional covariates and responses are valued,
respectively.}

\item{std_error}{standard deviation of the random variables
involved in the generation of the functional error \code{error_fdata}.
Defaults to \code{0.15}.}

\item{n_fpc}{number of FPC to be taken into account for the data generation.
Must be greater than \code{4} when \code{r_ik2018_flmfr} is applied, since
the first \eqn{4} FPC are null. Defaults to \code{50}.}

\item{concurrent}{flag to consider a concurrent FLMFR (degenerate case).
Defaults to \code{FALSE}.}

\item{parameters}{vector of parameters, only required for
\code{r_ik2018_flmfr}. Defaults to\cr \code{c(1.75, 0.8, 2.4, 0.25)}.}
}
\value{
A list with the following elements:
\item{\code{X_fdata}}{functional covariates, an
\code{\link[fda.usc]{fdata}} object of length \code{n}.}
\item{\code{error_fdata}}{functional errors, an
\code{\link[fda.usc]{fdata}} object of length \code{n}.}
\item{\code{beta}}{either the matrix with \eqn{\beta(s, t)} evaluated at
the \code{argvals} of \code{X_fdata} and \code{Y_fdata} (if
\code{concurrent = FALSE}) or a vector with \eqn{\beta(t)}
evaluated at the \code{argvals} of \code{X_fdata} (if
\code{concurrent = TRUE}).}
}
\description{
Simulation of \eqn{X}, a random variable in the Hilbert space
of square-integrable functions in \eqn{[a, b]}, \eqn{L^2([a, b])}, and
\eqn{\varepsilon}{\epsilon}, a random variable in \eqn{L^2([c, d])}.
Together with the bivariate kernel \eqn{\beta}, they are the necessary
elements for sampling a Functional Linear Model with  Functional Response
(FLMFR):
\deqn{Y(t) = \int_a^b X(s) \beta(s,t) ds + \varepsilon(t).}{
Y(t) = \int_a^b X(s) \beta(s,t) ds + \epsilon(t).}

The next functions sample \eqn{X} and \eqn{\varepsilon}{\epsilon}, and
construct \eqn{\beta}, using different proposals in the literature:
\itemize{
  \item{\code{r_cm2013_flmfr} is based on the numerical example given in
  Section 3 of Crambes and Mas (2013). Termed as S1 in Section 2 of
  García-Portugués et al. (2021).}
  \item{\code{r_ik2018_flmfr} is based on the numerical example given in
  Section 4 of Imaizumi and Kato (2018), but zeroing the first Functional
  Principal Components (FPC) coefficients of \eqn{\beta} (so the first FPC
  are not adequate for estimation). S3 in Section 2 of
  García-Portugués et al. (2021).}
  \item{\code{r_gof2021_flmfr} gives a numerical example in Section 2
  of García-Portugués et al. (2021), denoted therein as S2.}
}
}
\details{
Descriptions of the processes \eqn{X} and \eqn{\varepsilon}{\epsilon},
and of \eqn{\beta} can be seen in the references.
}
\examples{
# FLMFR based on Imaizumi and Kato (2018) adopting different Hilbert spaces
s <- seq(0, 1, l = 201)
t <- seq(2, 4, l = 301)
r_ik2018 <- r_ik2018_flmfr(n = 50, s = s, t = t, std_error = 1.5,
                           parameters = c(1.75, 0.8, 2.4, 0.25), n_fpc = 50)
plot(r_ik2018$X_fdata)
plot(r_ik2018$error_fdata)
image(x = s, y = t, z = r_ik2018$beta, col = viridisLite::viridis(20))

# FLMFR based on Cardot and Mas (2013) adopting different Hilbert spaces
r_cm2013 <- r_cm2013_flmfr(n = 50, s = s, t = t, std_error = 0.15,
                           n_fpc = 50)
plot(r_cm2013$X_fdata)
plot(r_cm2013$error_fdata)
image(x = s, y = t, z = r_cm2013$beta, col = viridisLite::viridis(20))

# FLMFR in García-Portugués et al. (2021) adopting different Hilbert spaces
r_gof2021 <- r_gof2021_flmfr(n = 50, s = s, t = t, std_error = 0.35,
                             concurrent = FALSE)
plot(r_gof2021$X_fdata)
plot(r_gof2021$error_fdata)
image(x = s, y = t, z = r_gof2021$beta, col = viridisLite::viridis(20))

# Concurrent model in García-Portugués et al. (2021)
r_gof2021 <- r_gof2021_flmfr(n = 50, s = s, t = s, std_error = 0.35,
                             concurrent = TRUE)
plot(r_gof2021$X_fdata)
plot(r_gof2021$error_fdata)
plot(r_gof2021$beta)
}
\references{
Cardot, H. and Mas, A. (2013). Asymptotics of prediction in functional linear
regression with functional outputs. \emph{Bernoulli}, 19(5B):2627--2651.
\doi{10.3150/12-BEJ469}

Imaizumi, M. and Kato, K. (2018). PCA-based estimation for functional linear
regression with functional responses. \emph{Journal of Multivariate
Analysis}, 163:15--36. \doi{10.1016/j.jmva.2017.10.001}

García-Portugués, E., Álvarez-Liébana, J., Álvarez-Pérez, G. and
Gonzalez-Manteiga, W. (2021). A goodness-of-fit test for the functional
linear model with functional response. \emph{Scandinavian Journal of
Statistics}, 48(2):502--528. \doi{10.1111/sjos.12486}
}
\author{
Javier Álvarez-Liébana.
}
