% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{fda.usc_efic}
\alias{fda.usc_efic}
\alias{fdata_cen}
\alias{func_mean}
\alias{inprod_fdata}
\title{Auxiliary functions for the \pkg{goffda} package}
\usage{
fdata_cen(X_fdata, mean_X = func_mean(X_fdata))

func_mean(X_fdata)

inprod_fdata(X_fdata1, X_fdata2 = NULL, int_rule = "trapezoid",
  as_matrix = TRUE, verbose = FALSE)
}
\arguments{
\item{X_fdata}{sample of functional data as an
\code{\link[fda.usc]{fdata}} object of length \code{n}.}

\item{mean_X}{functional mean of \code{X_fdata}.}

\item{X_fdata1, X_fdata2}{samples of functional
data as \code{\link[fda.usc]{fdata}} objects of lengths \eqn{n_1}
and \eqn{n_2}, respectively. Sample sizes can be different.}

\item{int_rule}{quadrature rule for approximating the definite
unidimensional integral: trapezoidal rule (\code{int_rule = "trapezoid"})
and extended Simpson rule (\code{int_rule = "Simpson"}) are available.
Defaults to \code{"trapezoid"}.}

\item{as_matrix}{flag to indicate if \code{inprod_fdata} returns a matrix
or the vector of its lower triangular part in column-major order.
Defaults to \code{TRUE}.}

\item{verbose}{whether to show or not information about the
\code{inprod_fdata} procedure.}
}
\description{
Auxiliary functions required for the methods
implemented in the \pkg{goffda} package, as enhancements of the auxiliary
functions \code{\link[fda.usc]{fdata.cen}} and
\code{\link[fda.usc:Descriptive]{func.mean}} from the
\code{\link[fda.usc]{fda.usc-package}}.
}
\details{
\itemize{
  \item{\code{func_mean}: computes the functional mean of
  \code{X_fdata}.}
  \item{\code{fdata_cen}: centers the
  functional data \code{X_fdata}.}
  \item{\code{inprod_fdata(X_fdata1)}:  computes as a row vector the
  elements of the lower triangular part of the inner products matrix
  (\code{X_fdata} vs \code{X_fdata}). If \code{as_matrix = TRUE}, the
  matrix of inner products is given.}
  \item{\code{inprod_fdata(X_fdata1, X_fdata2)}: computes the matrix of
  inner products (\code{as_matrix = TRUE} is forced) between \code{X_fdata1}
  and \code{X_fdata2}.}
}
}
\examples{
## fdata_cen() vs fda.usc::fdata_cen()

data(phoneme, package = "fda.usc")
mlearn <- phoneme$learn[1:10, ]
plot(fda.usc::fdata.cen(mlearn)$Xcen)
plot(fdata_cen(mlearn))

## inprod_fdata() vs fda.usc::inprod.fdata()

# inprod_fdata between mlearn and mlearn: as a row vector

A <- fda.usc::inprod.fdata(fdata1 = mlearn)
A[upper.tri(A, diag = TRUE)]
inprod_fdata(X_fdata1 = mlearn, int_rule = "trapezoid", as_matrix = FALSE)

# inprod_fdata between mlearn and mlearn: as a matrix

A <- fda.usc::inprod.fdata(fdata1 = mlearn)
A
inprod_fdata(X_fdata1 = mlearn, int_rule = "trapezoid", as_matrix = TRUE)

# inprod_fdata between mlearn and mlearn2: as a matrix

mlearn2 <- phoneme$learn[11:30, ]
A <- fda.usc::inprod.fdata(fdata1 = mlearn, fdata2 = mlearn2)
A
B <- inprod_fdata(X_fdata1 = mlearn, X_fdata2 = mlearn2,
int_rule = "trapezoid", as_matrix = TRUE)
B
\donttest{
## Efficiency comparisons

microbenchmark::microbenchmark(fda.usc::fdata.cen(mlearn), fdata_cen(mlearn),
                               times = 1e3, control = list(warmup = 20))

microbenchmark::microbenchmark(fda.usc::inprod.fdata(fdata1 = mlearn),
                               inprod_fdata(X_fdata1 = mlearn,
                               as_matrix = FALSE), times = 1e3,
                               control = list(warmup = 20))
}
}
\author{
Code iterated by Eduardo García-Portugués, Gonzalo Álvarez-Pérez,
and Javier Álvarez-Liébana from the \code{\link[fda.usc]{fda.usc-package}}
originals.
}
\keyword{internal}
