% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_deploy_helpers.R
\name{add_dockerfile}
\alias{add_dockerfile}
\alias{add_dockerfile_shinyproxy}
\alias{add_dockerfile_heroku}
\title{Create a Dockerfile for  Shiny App}
\usage{
add_dockerfile(
  path = "DESCRIPTION",
  output = "Dockerfile",
  pkg = get_golem_wd(),
  from = paste0("rocker/r-ver:", R.Version()$major, ".", R.Version()$minor),
  as = NULL,
  port = 80,
  host = "0.0.0.0",
  sysreqs = TRUE,
  repos = "https://cran.rstudio.com/",
  expand = FALSE,
  open = TRUE,
  update_tar_gz = TRUE,
  build_golem_from_source = TRUE
)

add_dockerfile_shinyproxy(
  path = "DESCRIPTION",
  output = "Dockerfile",
  pkg = get_golem_wd(),
  from = paste0("rocker/r-ver:", R.Version()$major, ".", R.Version()$minor),
  as = NULL,
  sysreqs = TRUE,
  repos = "https://cran.rstudio.com/",
  expand = FALSE,
  open = TRUE,
  update_tar_gz = TRUE,
  build_golem_from_source = TRUE
)

add_dockerfile_heroku(
  path = "DESCRIPTION",
  output = "Dockerfile",
  pkg = get_golem_wd(),
  from = paste0("rocker/r-ver:", R.Version()$major, ".", R.Version()$minor),
  as = NULL,
  sysreqs = TRUE,
  repos = "https://cran.rstudio.com/",
  expand = FALSE,
  open = TRUE,
  update_tar_gz = TRUE,
  build_golem_from_source = TRUE
)
}
\arguments{
\item{path}{path to the DESCRIPTION file to use as an input.}

\item{output}{name of the Dockerfile output.}

\item{pkg}{Path to the root of the package. Default is \code{get_golem_wd()}.}

\item{from}{The FROM of the Dockerfile. Default is FROM rocker/r-ver:
with \code{R.Version()$major} and \code{R.Version()$minor}.}

\item{as}{The AS of the Dockerfile. Default it NULL.}

\item{port}{The \code{options('shiny.port')} on which to run the Shiny App.
Default is 80.}

\item{host}{The \code{options('shiny.host')} on which to run the Shiny App.
Default is 0.0.0.0.}

\item{sysreqs}{boolean to check the system requirements}

\item{repos}{character vector, the base URL of the repositories}

\item{expand}{boolean, if \code{TRUE} each system requirement will be known his own RUN line}

\item{open}{boolean, default is \code{TRUE} open the Dockerfile file}

\item{update_tar_gz}{boolean, if \code{TRUE} and build_golem_from_source is also \code{TRUE} an updated tar.gz Package is created}

\item{build_golem_from_source}{boolean, if \code{TRUE} no tar.gz Package is created and the Dockerfile directly mount the source folder to build it}
}
\description{
Build a container containing your Shiny App. \code{add_dockerfile()} creates
a "classical" Dockerfile, while \code{add_dockerfile_shinyproxy()} and
\code{add_dockerfile_heroku()} creates platform specific Dockerfile.
}
\examples{
\donttest{
# Add a standard Dockerfile
if (interactive()){
   add_dockerfile()
}
# Add a Dockerfile for ShinyProxy
if (interactive()){
    add_dockerfile_shinyproxy()
}
# Add a Dockerfile for Heroku
if (interactive()){
    add_dockerfile_heroku()
}
}
}
