% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.good.R
\name{glm.good}
\alias{glm.good}
\title{Maximum Likelihood Estimation and Good Regression}
\usage{
glm.good ( formula , data , link = "log" , start = NULL )
}
\arguments{
\item{formula}{symbolic description of the model to be fitted. A typical predictor
has the form response ~ terms where the response is the integer-valued response
vector following a Good distribution with parameters s and z, and terms is a series of
predictors.}

\item{data}{an optional data frame with the variables in the model.}

\item{link}{character specification of link function: "logit", "log" or "identity".
By default link="log".}

\item{start}{a vector with the starting values for the model parameters. Used for numerically maximize
the likelihood function for parameters estimation. By default start = NULL.}
}
\value{
\code{glm.good} returns an object of class \code{glm.good} that is a list including:
\item{coefs}{ The vector of coefficients.}
\item{loglik}{ Log-likelihood of the fitted model.}
\item{vcov}{ Variance-covariance matrix of all model parameters
(derived from the Hessian matrix returned by nlm() ).}
\item{hess}{ Hessian matrix, returned by nlm().}
\item{fitted.values}{ The fitted mean values. These are obtained by
transforming the linear predictors by the link function inverse. }
}
\description{
\code{glm.good} is used to fit generalized linear models with a response variable following a
Good distribution with parameters z and s. \code{glm.good} allows incorporating predictors in
the model with a link function (log, logit and identity) that relates parameter z and
predictors. A summary method over an object of class \code{glm.good} provides essential
information regarding the fitted model such as parameters estimates, standard errors,
and some goodness-of-fit measures. A prediction method over an object of class \code{glm.good}
provides the fitted values with the estimated model and optionally standard errors and predictions
for a new data set.
}
\examples{
data ( "polar" )
mle <- glm.good ( cubnumber ~ 1 , link = "log", data = polar )
names ( mle )
mle$coefficients
mle$fitted.values
mean ( polar$cubnumber )
summary ( mle )
predict ( mle , newdata = NULL , se.fit = TRUE )
}
\references{
Good, J. (1953). The  population  frequencies  of  species  and  the  estimation  of  population
parameters. Biometrika, 40: 237–264.

Zörnig, P. and Altmann, G. (1995). Unified representation of zipf distributions.
Computational Statistics & Data Analysis, 19: 461–473.

Kulasekera, K.B. and Tonkyn, D. (1992). A new distribution with applications to survival
dispersal anddispersion. Communication in Statistics - Simulation and Computation,
21: 499–518.

Doray, L.G. and Luong, A. (1997). Efficient estimators for the good family.
Communications in Statistics - Simulation and Computation, 26: 1075–1088.

Johnson, N.L., Kemp, A.W. and Kotz, S. Univariate Discrete Distributions.
Wiley, Hoboken, 2005.

Kemp. A.W. (2010). Families of power series distributions, with particular
reference to the lerch family. Journal of Statistical Planning and Inference,
140:2255–2259.

Wood, D.C. (1992). The Computation of Polylogarithms. Technical report. UKC,
University of Kent, Canterbury, UK (KAR id:21052).
}
\seealso{
See also \code{\link[copula]{polylog}} from \pkg{copula}, \code{\link[good]{dgood}},
and \code{\link[good]{pgood}}, \code{\link[good]{qgood}} and \code{\link[good]{rgood}}
from \pkg{good}, and \code{\link[maxLik]{maxLik}} from \pkg{maxLik}.
}
\author{
Jordi Tur, David Moriña, Pere Puig, Alejandra Cabaña, Argimiro Arratia,
Amanda Fernández-Fontelo
}
