% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-modifyurl.R
\name{gar_shiny_auth}
\alias{gar_shiny_auth}
\title{Create Authentication within Shiny's server.R}
\usage{
gar_shiny_auth(session)
}
\arguments{
\item{session}{Shiny session argument}
}
\description{
This can be used at the top of the server function for authentication when you have used
  \link{gar_shiny_ui} to create a login page for your ui function.
}
\details{
If using  \link{gar_shiny_ui}, put this at the top of your server.R function
}
\examples{

\dontrun{
library(shiny)
library(googleAuthR)
gar_set_client()

fileSearch <- function(query) {
  googleAuthR::gar_api_generator("https://www.googleapis.com/drive/v3/files/",
                                "GET",
                                pars_args=list(q=query),
                                data_parse_function = function(x) x$files)()
}

## ui.R
ui <- fluidPage(title = "googleAuthR Shiny Demo",
                textInput("query", 
                label = "Google Drive query", 
                value = "mimeType != 'application/vnd.google-apps.folder'"),
                tableOutput("gdrive")
                )
                
## server.R
server <- function(input, output, session){

# this is not reactive, no need as you only reach here authenticated
gar_shiny_auth(session)

output$gdrive <- renderTable({
  req(input$query)
  
  # no need for with_shiny()
  fileSearch(input$query)
  
  })
  }

# gar_shiny_ui() needs to wrap the ui you have created above.
shinyApp(gar_shiny_ui(ui), server)
}
}
\seealso{
Other pre-load shiny authentication: \code{\link{gar_shiny_auth_url}},
  \code{\link{gar_shiny_login_ui}},
  \code{\link{gar_shiny_ui}}, \code{\link{silent_auth}}
}
\author{
Based on a gist by Joe Cheng, RStudio
}
