% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_sources.R
\name{cr_build_upload_gcs}
\alias{cr_build_upload_gcs}
\title{Create a StorageSource}
\usage{
cr_build_upload_gcs(
  local,
  remote = paste0(local, format(Sys.time(), "\%Y\%m\%d\%H\%M\%S"), ".tar.gz"),
  bucket = cr_bucket_get(),
  predefinedAcl = "bucketOwnerFullControl",
  deploy_folder = "deploy"
)
}
\arguments{
\item{local}{Local directory containing the Dockerfile etc. you wish to deploy}

\item{remote}{The name of the folder in your bucket}

\item{bucket}{The Google Cloud Storage bucket to upload to}

\item{predefinedAcl}{The ACL rules for the object uploaded.}

\item{deploy_folder}{Which folder to deploy from}
}
\value{
A Source object
}
\description{
This creates a \link{StorageSource} object after uploading to Google Cloud Storage
}
\details{
It copies the files into a folder call "deploy" in your working directory, then tars it for upload
}
\examples{

\dontrun{
cr_project_set("my-project")
cr_bucket_set("my-bucket")
my_gcs_source <- cr_build_upload_gcs("my_folder")
build1 <- cr_build("cloudbuild.yaml", source = my_gcs_source)

}
}
\seealso{
Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
