% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy-buildtriggers.R
\name{cr_deploy_git_html}
\alias{cr_deploy_git_html}
\title{Deploy HTML built from a repo each commit (Experimental)}
\usage{
cr_deploy_git_html(
  x,
  image = paste0(x, "-html"),
  rmd_folder = NULL,
  html_folder = NULL,
  branch = ".*",
  image_tag = "$SHORT_SHA",
  github_tag = NULL,
  timeout = 600L,
  edit_r = NULL,
  r_image = "gcr.io/gcer-public/packagetools:master",
  allowUnauthenticated = TRUE,
  region = cr_region_get(),
  projectId = cr_project_get()
)
}
\arguments{
\item{x}{The GitHub repo e.g. \code{MarkEdmondson1234/googleCloudRunner}}

\item{image}{The name of the image you want to build}

\item{rmd_folder}{A folder of Rmd files within GitHub source that will be built into HTML for serving via \link[rmarkdown]{render}}

\item{html_folder}{A folder of html to deploy within GitHub source.  Will be ignored if rmd_folder is not NULL}

\item{branch}{A regex of the GitHub branches that will trigger a build}

\item{image_tag}{What to tag the build docker image}

\item{github_tag}{Regexes matching what tags to build. If not NULL then argument branch will be ignored}

\item{timeout}{timeout for the Docker build}

\item{edit_r}{If you want to change the R code to render the HTML, supply R code via a file or string of R as per \link{cr_buildstep_r}}

\item{r_image}{The image that will run the R code from \code{edit_r}}

\item{allowUnauthenticated}{TRUE if can be reached from public HTTP address.}

\item{region}{The region for cloud run}

\item{projectId}{The project to build under}
}
\description{
This lets you set up triggers that will update a website each commit. You need to mirror the GitHub/Bitbucket repo onto Google Cloud Repositories for this to work.
}
\details{
Build trigger API is experimental so this function is in development.

This default R code is rendered in the rmd_folder:

\code{lapply(list.files('.', pattern = '.Rmd', full.names = TRUE),
      rmarkdown::render, output_format = 'html_document')}

You need to mirror the GitHub/Bitbucket repo onto Google Cloud Repositories for this to work
}
\examples{

\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
your_repo <- "MarkEdmondson1234/googleCloudRunner"
cr_deploy_git_html(your_repo, rmd_folder = "vignettes")

# change the Rmd rendering to pkgdown
r <- "devtools::install();pkgdown::build_site()"

cr_deploy_git_html(your_repo,
                   image = paste0(your_repo, "-pkgdown"),
                   rmd_folder = ".",
                   edit_r = r)

}
}
\seealso{
\link{cr_deploy_html} that lets you deploy HTML files

Other Deployment functions: 
\code{\link{cr_deploy_docker}()},
\code{\link{cr_deploy_github_docker}()},
\code{\link{cr_deploy_pkgdown}()},
\code{\link{cr_deploy_run}()},
\code{\link{cr_deploy_r}()}
}
\concept{Deployment functions}
