% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildtriggers.R
\name{cr_buildtrigger}
\alias{cr_buildtrigger}
\title{Creates a new `BuildTrigger`.This API is experimental.}
\usage{
cr_buildtrigger(
  name,
  trigger,
  build,
  description = paste("cr_buildtrigger: ", Sys.time()),
  tags = NULL,
  disabled = FALSE,
  substitutions = NULL,
  ignoredFiles = NULL,
  includedFiles = NULL,
  projectId = cr_project_get()
)
}
\arguments{
\item{name}{User assigned name of the trigger}

\item{trigger}{The trigger source which will be a \link{RepoSource} or a \link{GitHubEventsConfig}}

\item{build}{A file location within the trigger source to use for the build steps, or a \link{Build} object}

\item{description}{Human-readable description of this trigger}

\item{tags}{Tags for annotation of a `BuildTrigger`}

\item{disabled}{If true, the trigger will never result in a build}

\item{substitutions}{A named list of Build macro variables}

\item{ignoredFiles}{ignored_files and included_files are file glob matches extended with support for "**".}

\item{includedFiles}{If any of the files altered in the commit pass the ignored_files}

\item{projectId}{ID of the project for which to configure automatic builds}
}
\description{
Creates a new `BuildTrigger`.This API is experimental.
}
\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")
cloudbuild <- system.file("cloudbuild/cloudbuild.yaml",
                           package = "googleCloudRunner")
bb <- cr_build_make(cloudbuild)
github <- GitHubEventsConfig("MarkEdmondson1234/googleCloudRunner",
                             branch = "master")
# creates a trigger with named subtitutions
ss <- list(`_MYVAR` = "TEST1",
           `_GITHUB` = "MarkEdmondson1234/googleCloudRunner")

\dontrun{

cr_buildtrigger("trig1", trigger = github, build = bb)

cr_buildtrigger("trig2", trigger = github,
                build = bb,
                substitutions = ss)

# create a trigger that will build from the file in the repo
# this is similar to what cr_deploy_docker_github() does
cr_buildtrigger("trig3", trigger = github,
                build = "inst/cloudbuild/cloudbuild.yaml")

build_docker <- cr_build_make(
                    cr_build_yaml(
                      steps = cr_buildstep_docker("build-dockerfile"),
                      images = "gcr.io/my-project/my-image"
                    ))

cr_buildtrigger("trig4", trigger = github,
                 build = build_docker)
}
}
\seealso{
Other BuildTrigger functions: 
\code{\link{BuildTrigger}()},
\code{\link{GitHubEventsConfig}()},
\code{\link{cr_buildtrigger_delete}()},
\code{\link{cr_buildtrigger_edit}()},
\code{\link{cr_buildtrigger_get}()},
\code{\link{cr_buildtrigger_list}()},
\code{\link{cr_buildtrigger_make}()},
\code{\link{cr_buildtrigger_run}()}
}
\concept{BuildTrigger functions}
