% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/container.R
\name{gce_pull_registry}
\alias{gce_pull_registry}
\title{Load a previously saved private Google Container}
\usage{
gce_pull_registry(instance, container_name, container_url = "gcr.io",
  pull_only = FALSE, project = gce_get_global_project(), ...)
}
\arguments{
\item{instance}{The VM to run within}

\item{container_name}{The name of the saved container}

\item{container_url}{The URL of where the container was saved}

\item{pull_only}{If TRUE, will not run the container, only pull to the VM}

\item{project}{Project ID for this request, default as set by \link{gce_get_global_project}}

\item{...}{Other arguments passed to \link{docker_run} or \link{docker_pull}

After starting a VM, you can load the container again using this command.

\itemize{
  \item For Shiny based containers, pass \code{"-p 80:3838"} to run it at the IP URL
  \item For RStudio based containers, pass \code{"-p 80:8787"} to run it at the IP URL
 }}
}
\value{
The instance
}
\description{
Load a previously saved private Google Container
}

