% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future.R
\name{gce_future_install_packages}
\alias{gce_future_install_packages}
\title{Install R packages onto an instance's stopped docker image}
\usage{
gce_future_install_packages(instance, docker_image, cran_packages = NULL,
  github_packages = NULL)
}
\arguments{
\item{instance}{The instance running the container}

\item{docker_image}{A docker image to install packages within.}

\item{cran_packages}{A character vector of CRAN packages to be installed}

\item{github_packages}{A character vector of devtools packages to be installed}
}
\value{
TRUE if successful
}
\description{
Install R packages onto an instance's stopped docker image
}
\details{
See the images on the instance via \code{docker_cmd(instance, "images")}

If using devtools github, will look for an auth token via \code{devtools::github_pat()}.  
  This is an environment variable called \code{GITHUB_PAT} 

 Will start a container, install packages and then commit 
   the container to an image of the same name via \code{docker commit -m "installed packages via gceR"}
}
