% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{gtm_tags_update}
\alias{gtm_tags_update}
\title{Update an existing tag}
\usage{
gtm_tags_update(account_id, container_id, workspace_id, tag_id, tag_object)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{tag_id}{Tag Id}

\item{tag_object}{Tag Object}
}
\description{
This takes a tag resource and overwrites the existing tag in GTM
}
\examples{
\dontrun{

accountId <- 1234567
containerId <- 7654321
workspaceId <- 5
tagId <- 11

tag <- list(
  name = "Example DataLayer Push",
  type = "html",
  tagFiringOption = "oncePerEvent",
  parameter = list(
    list(
      type = "template",
      key = "html",
      value = "<script>\n   window.dataLayer=window.dataLayer||[];\n   
               window.dataLayer.push({\"event\": \"demoEvent\"});\n
               </script>"
    ),
    list(
      type = "boolean",
      key = "supportDocumentWrite",
      value = "false"
    )
  ),
  firingTriggerId = 20,
  tagFiringOption = "oncePerPage"
)

updatedTag <- gtm_tags_update(accountId, containerId, workspaceId, tagId, tag)
}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/tags/update}

Other tag functions: 
\code{\link{gtm_tags_create}()},
\code{\link{gtm_tags_delete}()},
\code{\link{gtm_tags_get}()},
\code{\link{gtm_tags_list}()},
\code{\link{gtm_tags_revert}()}
}
\concept{tag functions}
