% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_trash.R
\name{drive_trash}
\alias{drive_trash}
\alias{drive_untrash}
\title{Move Drive files to or from trash}
\usage{
drive_trash(file, verbose = TRUE)

drive_untrash(file, verbose = TRUE)
}
\arguments{
\item{file}{Something that identifies the file(s) of interest on your Google
Drive. Can be a character vector of names/paths, a character vector of file
ids or URLs marked with \code{\link{as_id}()}, or a \code{\link{dribble}}.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per
  item.
}
\description{
Move Drive files to or from trash
}
\examples{
\dontrun{
## Create a file and put it in the trash.
file <- drive_upload(drive_example("chicken.txt"), "chicken-trash.txt")
drive_trash("chicken-trash.txt")

## Confirm it's in the trash
drive_find(trashed = TRUE)

## Remove it from the trash and confirm
drive_untrash("chicken-trash.txt")
drive_find(trashed = TRUE)

## Clean up
drive_rm("chicken-trash.txt")
}
}
