% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_update.R
\name{drive_update}
\alias{drive_update}
\title{Update an existing Drive file}
\usage{
drive_update(file, media = NULL, ..., verbose = TRUE)
}
\arguments{
\item{file}{Something that identifies the file of interest on your Google
Drive. Can be a name or path, a file id or URL marked with \code{\link[=as_id]{as_id()}}, or a
\code{\link{dribble}}.}

\item{media}{Character, path to the local file to upload.}

\item{...}{Named parameters to pass along to the Drive API. Has the tidy dots
semantics that come from using \code{\link[rlang:list2]{rlang::list2()}}. You can affect the
metadata of the target file by specifying properties of the Files resource
via \code{...}. Read the "Request body" section of the Drive API docs for the
associated endpoint to learn about relevant parameters.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per item.
}
\description{
Update an existing Drive file id with new content ("media" in Drive
API-speak), new metadata, or both.  To create a new file or update existing,
depending on whether the Drive file already exists, see \code{\link[=drive_put]{drive_put()}}.
}
\examples{
\dontrun{
## Create a new file, so we can update it
x <- drive_upload(drive_example("chicken.csv"))

## Update the file with new media
x <- x \%>\%
  drive_update(drive_example("chicken.txt"))

## Update the file with new metadata.
## Notice here `name` is not an argument of `drive_update()`, we are passing
## this to the API via the `...``
x <- x \%>\%
  drive_update(name = "CHICKENS!")

## We can add a parent folder by passing `addParents` via `...`.
folder <- drive_mkdir("second-parent-folder")
x <- x \%>\%
  drive_update(addParents = as_id(folder))
## Verify the file now has multiple parents
purrr::pluck(x, "drive_resource", 1, "parents")

## Update the file with new media AND new metadata
x <- x \%>\%
  drive_update(drive_example("chicken.txt"), name = "chicken-poem-again.txt")

## Clean up
drive_rm(x, folder)
}
}
\seealso{
Wraps the \code{files.update} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/v3/reference/files/update}
}

This function supports media upload:
\itemize{
\item \url{https://developers.google.com/drive/v3/web/manage-uploads}
}
}
